@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.NetworkFabricControllerArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.ExpressRouteConnectionInformationArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.ExpressRouteConnectionInformationArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.ManagedResourceGroupConfigurationArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.ManagedResourceGroupConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The NetworkFabricController resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### NetworkFabricControllers_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkFabricController = new AzureNative.ManagedNetworkFabric.NetworkFabricController("networkFabricController", new()
 *     {
 *         Annotation = "lab 1",
 *         InfrastructureExpressRouteConnections = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.ExpressRouteConnectionInformationArgs
 *             {
 *                 ExpressRouteAuthorizationKey = "xxxxxxx",
 *                 ExpressRouteCircuitId = "/subscriptions/xxxxx/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteCircuits/expressRouteCircuitName",
 *             },
 *         },
 *         Ipv4AddressSpace = "172.253.0.0/19",
 *         Location = "eastus",
 *         ManagedResourceGroupConfiguration = new AzureNative.ManagedNetworkFabric.Inputs.ManagedResourceGroupConfigurationArgs
 *         {
 *             Location = "eastus",
 *             Name = "managedResourceGroupName",
 *         },
 *         NetworkFabricControllerName = "NetworkControllerName",
 *         ResourceGroupName = "resourceGroupName",
 *         WorkloadExpressRouteConnections = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.ExpressRouteConnectionInformationArgs
 *             {
 *                 ExpressRouteAuthorizationKey = "xxxxx",
 *                 ExpressRouteCircuitId = "/subscriptions/xxxxx/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteCircuits/expressRouteCircuitName",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewNetworkFabricController(ctx, "networkFabricController", &managednetworkfabric.NetworkFabricControllerArgs{
 * 			Annotation: pulumi.String("lab 1"),
 * 			InfrastructureExpressRouteConnections: []managednetworkfabric.ExpressRouteConnectionInformationArgs{
 * 				{
 * 					ExpressRouteAuthorizationKey: pulumi.String("xxxxxxx"),
 * 					ExpressRouteCircuitId:        pulumi.String("/subscriptions/xxxxx/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteCircuits/expressRouteCircuitName"),
 * 				},
 * 			},
 * 			Ipv4AddressSpace: pulumi.String("172.253.0.0/19"),
 * 			Location:         pulumi.String("eastus"),
 * 			ManagedResourceGroupConfiguration: &managednetworkfabric.ManagedResourceGroupConfigurationArgs{
 * 				Location: pulumi.String("eastus"),
 * 				Name:     pulumi.String("managedResourceGroupName"),
 * 			},
 * 			NetworkFabricControllerName: pulumi.String("NetworkControllerName"),
 * 			ResourceGroupName:           pulumi.String("resourceGroupName"),
 * 			WorkloadExpressRouteConnections: []managednetworkfabric.ExpressRouteConnectionInformationArgs{
 * 				{
 * 					ExpressRouteAuthorizationKey: pulumi.String("xxxxx"),
 * 					ExpressRouteCircuitId:        pulumi.String("/subscriptions/xxxxx/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteCircuits/expressRouteCircuitName"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkFabricController;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkFabricControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkFabricController = new NetworkFabricController("networkFabricController", NetworkFabricControllerArgs.builder()
 *             .annotation("lab 1")
 *             .infrastructureExpressRouteConnections(Map.ofEntries(
 *                 Map.entry("expressRouteAuthorizationKey", "xxxxxxx"),
 *                 Map.entry("expressRouteCircuitId", "/subscriptions/xxxxx/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteCircuits/expressRouteCircuitName")
 *             ))
 *             .ipv4AddressSpace("172.253.0.0/19")
 *             .location("eastus")
 *             .managedResourceGroupConfiguration(Map.ofEntries(
 *                 Map.entry("location", "eastus"),
 *                 Map.entry("name", "managedResourceGroupName")
 *             ))
 *             .networkFabricControllerName("NetworkControllerName")
 *             .resourceGroupName("resourceGroupName")
 *             .workloadExpressRouteConnections(Map.ofEntries(
 *                 Map.entry("expressRouteAuthorizationKey", "xxxxx"),
 *                 Map.entry("expressRouteCircuitId", "/subscriptions/xxxxx/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteCircuits/expressRouteCircuitName")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NetworkFabricController NetworkFabricName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/{networkFabricControllerName}
 * ```
 * @property annotation Switch configuration description.
 * @property infrastructureExpressRouteConnections As part of an update, the Infrastructure ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Infrastructure services. (This is a Mandatory attribute)
 * @property ipv4AddressSpace IPv4 Network Fabric Controller Address Space.
 * @property ipv6AddressSpace IPv6 Network Fabric Controller Address Space.
 * @property location The geo-location where the resource lives
 * @property managedResourceGroupConfiguration Managed Resource Group configuration properties.
 * @property networkFabricControllerName Name of the Network Fabric Controller
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property workloadExpressRouteConnections As part of an update, the workload ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Workload services. (This is a Mandatory attribute).
 */
public data class NetworkFabricControllerArgs(
    public val `annotation`: Output<String>? = null,
    public val infrastructureExpressRouteConnections:
    Output<List<ExpressRouteConnectionInformationArgs>>? = null,
    public val ipv4AddressSpace: Output<String>? = null,
    public val ipv6AddressSpace: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedResourceGroupConfiguration: Output<ManagedResourceGroupConfigurationArgs>? =
        null,
    public val networkFabricControllerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workloadExpressRouteConnections: Output<List<ExpressRouteConnectionInformationArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.NetworkFabricControllerArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.NetworkFabricControllerArgs =
        com.pulumi.azurenative.managednetworkfabric.NetworkFabricControllerArgs.builder()
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .infrastructureExpressRouteConnections(
                infrastructureExpressRouteConnections?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .ipv4AddressSpace(ipv4AddressSpace?.applyValue({ args0 -> args0 }))
            .ipv6AddressSpace(ipv6AddressSpace?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedResourceGroupConfiguration(
                managedResourceGroupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .networkFabricControllerName(networkFabricControllerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workloadExpressRouteConnections(
                workloadExpressRouteConnections?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [NetworkFabricControllerArgs].
 */
@PulumiTagMarker
public class NetworkFabricControllerArgsBuilder internal constructor() {
    private var `annotation`: Output<String>? = null

    private var infrastructureExpressRouteConnections:
        Output<List<ExpressRouteConnectionInformationArgs>>? = null

    private var ipv4AddressSpace: Output<String>? = null

    private var ipv6AddressSpace: Output<String>? = null

    private var location: Output<String>? = null

    private var managedResourceGroupConfiguration: Output<ManagedResourceGroupConfigurationArgs>? =
        null

    private var networkFabricControllerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workloadExpressRouteConnections: Output<List<ExpressRouteConnectionInformationArgs>>? =
        null

    /**
     * @param value Switch configuration description.
     */
    @JvmName("toqayebfabrtgujs")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value As part of an update, the Infrastructure ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Infrastructure services. (This is a Mandatory attribute)
     */
    @JvmName("iveygbqgjmsjwill")
    public suspend
    fun infrastructureExpressRouteConnections(`value`: Output<List<ExpressRouteConnectionInformationArgs>>) {
        this.infrastructureExpressRouteConnections = value
    }

    @JvmName("lavrmdtdnlelfnlh")
    public suspend fun infrastructureExpressRouteConnections(
        vararg
        values: Output<ExpressRouteConnectionInformationArgs>,
    ) {
        this.infrastructureExpressRouteConnections = Output.all(values.asList())
    }

    /**
     * @param values As part of an update, the Infrastructure ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Infrastructure services. (This is a Mandatory attribute)
     */
    @JvmName("oroqkicoerigutth")
    public suspend
    fun infrastructureExpressRouteConnections(values: List<Output<ExpressRouteConnectionInformationArgs>>) {
        this.infrastructureExpressRouteConnections = Output.all(values)
    }

    /**
     * @param value IPv4 Network Fabric Controller Address Space.
     */
    @JvmName("rhthhqyvwtplhupn")
    public suspend fun ipv4AddressSpace(`value`: Output<String>) {
        this.ipv4AddressSpace = value
    }

    /**
     * @param value IPv6 Network Fabric Controller Address Space.
     */
    @JvmName("rolokmauhcaxtuju")
    public suspend fun ipv6AddressSpace(`value`: Output<String>) {
        this.ipv6AddressSpace = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nrhsttwyosrlgtbx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Managed Resource Group configuration properties.
     */
    @JvmName("tsgnxxykjusxbona")
    public suspend
    fun managedResourceGroupConfiguration(`value`: Output<ManagedResourceGroupConfigurationArgs>) {
        this.managedResourceGroupConfiguration = value
    }

    /**
     * @param value Name of the Network Fabric Controller
     */
    @JvmName("yaipwdlyqkaxdfyl")
    public suspend fun networkFabricControllerName(`value`: Output<String>) {
        this.networkFabricControllerName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cmusqukkmjvmvhni")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xwaotiwwnkfiqldv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value As part of an update, the workload ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Workload services. (This is a Mandatory attribute).
     */
    @JvmName("vkaimmovnyeponbp")
    public suspend
    fun workloadExpressRouteConnections(`value`: Output<List<ExpressRouteConnectionInformationArgs>>) {
        this.workloadExpressRouteConnections = value
    }

    @JvmName("debyayuavacqcjcd")
    public suspend fun workloadExpressRouteConnections(
        vararg
        values: Output<ExpressRouteConnectionInformationArgs>,
    ) {
        this.workloadExpressRouteConnections = Output.all(values.asList())
    }

    /**
     * @param values As part of an update, the workload ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Workload services. (This is a Mandatory attribute).
     */
    @JvmName("rcfqdqkmrwhadgxe")
    public suspend
    fun workloadExpressRouteConnections(values: List<Output<ExpressRouteConnectionInformationArgs>>) {
        this.workloadExpressRouteConnections = Output.all(values)
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("jvhfhmvprpmvnsya")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value As part of an update, the Infrastructure ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Infrastructure services. (This is a Mandatory attribute)
     */
    @JvmName("ipwrcfsbxmmalxpq")
    public suspend
    fun infrastructureExpressRouteConnections(`value`: List<ExpressRouteConnectionInformationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureExpressRouteConnections = mapped
    }

    /**
     * @param argument As part of an update, the Infrastructure ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Infrastructure services. (This is a Mandatory attribute)
     */
    @JvmName("eusrmkeyxjdwieyi")
    public suspend
    fun infrastructureExpressRouteConnections(argument: List<suspend ExpressRouteConnectionInformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExpressRouteConnectionInformationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.infrastructureExpressRouteConnections = mapped
    }

    /**
     * @param argument As part of an update, the Infrastructure ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Infrastructure services. (This is a Mandatory attribute)
     */
    @JvmName("pjigpsgiacghsomw")
    public suspend fun infrastructureExpressRouteConnections(
        vararg
        argument: suspend ExpressRouteConnectionInformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ExpressRouteConnectionInformationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.infrastructureExpressRouteConnections = mapped
    }

    /**
     * @param argument As part of an update, the Infrastructure ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Infrastructure services. (This is a Mandatory attribute)
     */
    @JvmName("sahjirffsmpqdety")
    public suspend
    fun infrastructureExpressRouteConnections(argument: suspend ExpressRouteConnectionInformationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExpressRouteConnectionInformationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.infrastructureExpressRouteConnections = mapped
    }

    /**
     * @param values As part of an update, the Infrastructure ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Infrastructure services. (This is a Mandatory attribute)
     */
    @JvmName("tkjuqqfhgjvdhnfo")
    public suspend fun infrastructureExpressRouteConnections(
        vararg
        values: ExpressRouteConnectionInformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.infrastructureExpressRouteConnections = mapped
    }

    /**
     * @param value IPv4 Network Fabric Controller Address Space.
     */
    @JvmName("gdrbpgcvyqfxhfad")
    public suspend fun ipv4AddressSpace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4AddressSpace = mapped
    }

    /**
     * @param value IPv6 Network Fabric Controller Address Space.
     */
    @JvmName("tcsibmvwmntxnadn")
    public suspend fun ipv6AddressSpace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressSpace = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vfaevxbimeqyeusu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Managed Resource Group configuration properties.
     */
    @JvmName("knnngudmirtynbuv")
    public suspend
    fun managedResourceGroupConfiguration(`value`: ManagedResourceGroupConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param argument Managed Resource Group configuration properties.
     */
    @JvmName("jewtggkhkutqxgcq")
    public suspend
    fun managedResourceGroupConfiguration(argument: suspend ManagedResourceGroupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedResourceGroupConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param value Name of the Network Fabric Controller
     */
    @JvmName("kacjinnnskeelexe")
    public suspend fun networkFabricControllerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFabricControllerName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mjisfcljxycchwuy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("thxpkxhlwstdtsqy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nygqfxcyifcfoyrk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value As part of an update, the workload ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Workload services. (This is a Mandatory attribute).
     */
    @JvmName("smbhrolcnvmcapbh")
    public suspend
    fun workloadExpressRouteConnections(`value`: List<ExpressRouteConnectionInformationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadExpressRouteConnections = mapped
    }

    /**
     * @param argument As part of an update, the workload ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Workload services. (This is a Mandatory attribute).
     */
    @JvmName("kyiyjfsugqxwedea")
    public suspend
    fun workloadExpressRouteConnections(argument: List<suspend ExpressRouteConnectionInformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExpressRouteConnectionInformationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.workloadExpressRouteConnections = mapped
    }

    /**
     * @param argument As part of an update, the workload ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Workload services. (This is a Mandatory attribute).
     */
    @JvmName("dacsvtspibeglvmr")
    public suspend fun workloadExpressRouteConnections(
        vararg
        argument: suspend ExpressRouteConnectionInformationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ExpressRouteConnectionInformationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.workloadExpressRouteConnections = mapped
    }

    /**
     * @param argument As part of an update, the workload ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Workload services. (This is a Mandatory attribute).
     */
    @JvmName("erphwathlpliakpk")
    public suspend
    fun workloadExpressRouteConnections(argument: suspend ExpressRouteConnectionInformationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExpressRouteConnectionInformationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.workloadExpressRouteConnections = mapped
    }

    /**
     * @param values As part of an update, the workload ExpressRoute CircuitID should be provided to create and Provision a NFC. This Express route is dedicated for Workload services. (This is a Mandatory attribute).
     */
    @JvmName("fdsrvdunhppsojjy")
    public suspend fun workloadExpressRouteConnections(
        vararg
        values: ExpressRouteConnectionInformationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workloadExpressRouteConnections = mapped
    }

    internal fun build(): NetworkFabricControllerArgs = NetworkFabricControllerArgs(
        `annotation` = `annotation`,
        infrastructureExpressRouteConnections = infrastructureExpressRouteConnections,
        ipv4AddressSpace = ipv4AddressSpace,
        ipv6AddressSpace = ipv6AddressSpace,
        location = location,
        managedResourceGroupConfiguration = managedResourceGroupConfiguration,
        networkFabricControllerName = networkFabricControllerName,
        resourceGroupName = resourceGroupName,
        tags = tags,
        workloadExpressRouteConnections = workloadExpressRouteConnections,
    )
}
