@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [NetworkRack].
 */
@PulumiTagMarker
public class NetworkRackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkRackArgs = NetworkRackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkRackArgsBuilder.() -> Unit) {
        val builder = NetworkRackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NetworkRack {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.NetworkRack(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkRack(builtJavaResource)
    }
}

/**
 * The NetworkRack resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### NetworkRacks_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkRack = new AzureNative.ManagedNetworkFabric.NetworkRack("networkRack", new()
 *     {
 *         Annotation = "null",
 *         Location = "eastus",
 *         NetworkFabricId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabrics/networkFabricName",
 *         NetworkRackName = "networkRackName",
 *         NetworkRackSku = "RackSKU",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "keyID", "keyValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewNetworkRack(ctx, "networkRack", &managednetworkfabric.NetworkRackArgs{
 * 			Annotation:        pulumi.String("null"),
 * 			Location:          pulumi.String("eastus"),
 * 			NetworkFabricId:   pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabrics/networkFabricName"),
 * 			NetworkRackName:   pulumi.String("networkRackName"),
 * 			NetworkRackSku:    pulumi.String("RackSKU"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"keyID": pulumi.String("keyValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkRack;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkRackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkRack = new NetworkRack("networkRack", NetworkRackArgs.builder()
 *             .annotation("null")
 *             .location("eastus")
 *             .networkFabricId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabrics/networkFabricName")
 *             .networkRackName("networkRackName")
 *             .networkRackSku("RackSKU")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.of("keyID", "keyValue"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NetworkRack networkRackName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkRacks/{networkRackName}
 * ```
 */
public class NetworkRack internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.NetworkRack,
) : KotlinCustomResource(javaResource, NetworkRackMapper) {
    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of network device ARM resource ids.
     */
    public val networkDevices: Output<List<String>>
        get() = javaResource.networkDevices().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Network Fabric ARM resource id.
     */
    public val networkFabricId: Output<String>
        get() = javaResource.networkFabricId().applyValue({ args0 -> args0 })

    /**
     * Network Rack SKU name.
     */
    public val networkRackSku: Output<String>
        get() = javaResource.networkRackSku().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NetworkRackMapper : ResourceMapper<NetworkRack> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.NetworkRack::class == javaResource::class

    override fun map(javaResource: Resource): NetworkRack = NetworkRack(
        javaResource as
            com.pulumi.azurenative.managednetworkfabric.NetworkRack,
    )
}

/**
 * @see [NetworkRack].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkRack].
 */
public suspend fun networkRack(name: String, block: suspend NetworkRackResourceBuilder.() -> Unit):
    NetworkRack {
    val builder = NetworkRackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkRack].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkRack(name: String): NetworkRack {
    val builder = NetworkRackResourceBuilder()
    builder.name(name)
    return builder.build()
}
