@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.BgpConfigurationArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.AllowASOverride
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.BooleanEnumProperty
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * BGP configuration properties
 * @property allowAS Allows for routes to be received and processed even if the router detects its own ASN in the AS-Path. 0 is disable, Possible values are 1-10, default is 2.
 * @property allowASOverride Enable Or Disable state.
 * @property annotation Switch configuration description.
 * @property defaultRouteOriginate Originate a defaultRoute. Ex: "True" | "False".
 * @property ipv4ListenRangePrefixes BGP Ipv4 ListenRange.
 * @property ipv4NeighborAddress List with stringified ipv4NeighborAddresses.
 * @property ipv6ListenRangePrefixes BGP Ipv6 ListenRange.
 * @property ipv6NeighborAddress List with stringified IPv6 Neighbor Address.
 * @property peerASN Peer ASN. Example: 65047.
 */
public data class BgpConfigurationArgs(
    public val allowAS: Output<Int>? = null,
    public val allowASOverride: Output<Either<String, AllowASOverride>>? = null,
    public val `annotation`: Output<String>? = null,
    public val defaultRouteOriginate: Output<Either<String, BooleanEnumProperty>>? = null,
    public val ipv4ListenRangePrefixes: Output<List<String>>? = null,
    public val ipv4NeighborAddress: Output<List<NeighborAddressArgs>>? = null,
    public val ipv6ListenRangePrefixes: Output<List<String>>? = null,
    public val ipv6NeighborAddress: Output<List<NeighborAddressArgs>>? = null,
    public val peerASN: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.BgpConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.BgpConfigurationArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.BgpConfigurationArgs.builder()
            .allowAS(allowAS?.applyValue({ args0 -> args0 }))
            .allowASOverride(
                allowASOverride?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .defaultRouteOriginate(
                defaultRouteOriginate?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .ipv4ListenRangePrefixes(
                ipv4ListenRangePrefixes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .ipv4NeighborAddress(
                ipv4NeighborAddress?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipv6ListenRangePrefixes(
                ipv6ListenRangePrefixes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .ipv6NeighborAddress(
                ipv6NeighborAddress?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .peerASN(peerASN.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BgpConfigurationArgs].
 */
@PulumiTagMarker
public class BgpConfigurationArgsBuilder internal constructor() {
    private var allowAS: Output<Int>? = null

    private var allowASOverride: Output<Either<String, AllowASOverride>>? = null

    private var `annotation`: Output<String>? = null

    private var defaultRouteOriginate: Output<Either<String, BooleanEnumProperty>>? = null

    private var ipv4ListenRangePrefixes: Output<List<String>>? = null

    private var ipv4NeighborAddress: Output<List<NeighborAddressArgs>>? = null

    private var ipv6ListenRangePrefixes: Output<List<String>>? = null

    private var ipv6NeighborAddress: Output<List<NeighborAddressArgs>>? = null

    private var peerASN: Output<Int>? = null

    /**
     * @param value Allows for routes to be received and processed even if the router detects its own ASN in the AS-Path. 0 is disable, Possible values are 1-10, default is 2.
     */
    @JvmName("iwixkfqtrefmrkcu")
    public suspend fun allowAS(`value`: Output<Int>) {
        this.allowAS = value
    }

    /**
     * @param value Enable Or Disable state.
     */
    @JvmName("cknicqbdrheebiqa")
    public suspend fun allowASOverride(`value`: Output<Either<String, AllowASOverride>>) {
        this.allowASOverride = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("kmngryemdmwowehn")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value Originate a defaultRoute. Ex: "True" | "False".
     */
    @JvmName("kurgcqpjsvjhshff")
    public suspend fun defaultRouteOriginate(`value`: Output<Either<String, BooleanEnumProperty>>) {
        this.defaultRouteOriginate = value
    }

    /**
     * @param value BGP Ipv4 ListenRange.
     */
    @JvmName("bjnujeeanpgadiua")
    public suspend fun ipv4ListenRangePrefixes(`value`: Output<List<String>>) {
        this.ipv4ListenRangePrefixes = value
    }

    @JvmName("clwxtoimqntnnpvs")
    public suspend fun ipv4ListenRangePrefixes(vararg values: Output<String>) {
        this.ipv4ListenRangePrefixes = Output.all(values.asList())
    }

    /**
     * @param values BGP Ipv4 ListenRange.
     */
    @JvmName("stvnqptjgmasrikw")
    public suspend fun ipv4ListenRangePrefixes(values: List<Output<String>>) {
        this.ipv4ListenRangePrefixes = Output.all(values)
    }

    /**
     * @param value List with stringified ipv4NeighborAddresses.
     */
    @JvmName("nmqnadbxxfnelmus")
    public suspend fun ipv4NeighborAddress(`value`: Output<List<NeighborAddressArgs>>) {
        this.ipv4NeighborAddress = value
    }

    @JvmName("nuscnjkapdgokskw")
    public suspend fun ipv4NeighborAddress(vararg values: Output<NeighborAddressArgs>) {
        this.ipv4NeighborAddress = Output.all(values.asList())
    }

    /**
     * @param values List with stringified ipv4NeighborAddresses.
     */
    @JvmName("hslordjwhsmlwjea")
    public suspend fun ipv4NeighborAddress(values: List<Output<NeighborAddressArgs>>) {
        this.ipv4NeighborAddress = Output.all(values)
    }

    /**
     * @param value BGP Ipv6 ListenRange.
     */
    @JvmName("hoiirquotpvlscox")
    public suspend fun ipv6ListenRangePrefixes(`value`: Output<List<String>>) {
        this.ipv6ListenRangePrefixes = value
    }

    @JvmName("rtfuflkdllxjfefj")
    public suspend fun ipv6ListenRangePrefixes(vararg values: Output<String>) {
        this.ipv6ListenRangePrefixes = Output.all(values.asList())
    }

    /**
     * @param values BGP Ipv6 ListenRange.
     */
    @JvmName("aqbojdusqbbefouh")
    public suspend fun ipv6ListenRangePrefixes(values: List<Output<String>>) {
        this.ipv6ListenRangePrefixes = Output.all(values)
    }

    /**
     * @param value List with stringified IPv6 Neighbor Address.
     */
    @JvmName("kjblwxuenbstvvmj")
    public suspend fun ipv6NeighborAddress(`value`: Output<List<NeighborAddressArgs>>) {
        this.ipv6NeighborAddress = value
    }

    @JvmName("pfputnxfufiahxta")
    public suspend fun ipv6NeighborAddress(vararg values: Output<NeighborAddressArgs>) {
        this.ipv6NeighborAddress = Output.all(values.asList())
    }

    /**
     * @param values List with stringified IPv6 Neighbor Address.
     */
    @JvmName("mpvldlgqsbuvpccl")
    public suspend fun ipv6NeighborAddress(values: List<Output<NeighborAddressArgs>>) {
        this.ipv6NeighborAddress = Output.all(values)
    }

    /**
     * @param value Peer ASN. Example: 65047.
     */
    @JvmName("sjrgftotklveaohq")
    public suspend fun peerASN(`value`: Output<Int>) {
        this.peerASN = value
    }

    /**
     * @param value Allows for routes to be received and processed even if the router detects its own ASN in the AS-Path. 0 is disable, Possible values are 1-10, default is 2.
     */
    @JvmName("vuecindleykkfauw")
    public suspend fun allowAS(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowAS = mapped
    }

    /**
     * @param value Enable Or Disable state.
     */
    @JvmName("hecbaoldnfradmaw")
    public suspend fun allowASOverride(`value`: Either<String, AllowASOverride>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowASOverride = mapped
    }

    /**
     * @param value Enable Or Disable state.
     */
    @JvmName("unlsmjmdkaysqyoi")
    public fun allowASOverride(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AllowASOverride>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowASOverride = mapped
    }

    /**
     * @param value Enable Or Disable state.
     */
    @JvmName("tpgmcldsdaryktlv")
    public fun allowASOverride(`value`: AllowASOverride) {
        val toBeMapped = Either.ofRight<String, AllowASOverride>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowASOverride = mapped
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("bdpqvetibohnnpcw")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value Originate a defaultRoute. Ex: "True" | "False".
     */
    @JvmName("frylaqxolnuvofxn")
    public suspend fun defaultRouteOriginate(`value`: Either<String, BooleanEnumProperty>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultRouteOriginate = mapped
    }

    /**
     * @param value Originate a defaultRoute. Ex: "True" | "False".
     */
    @JvmName("awesdlaongfujnhq")
    public fun defaultRouteOriginate(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BooleanEnumProperty>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultRouteOriginate = mapped
    }

    /**
     * @param value Originate a defaultRoute. Ex: "True" | "False".
     */
    @JvmName("nnclrcxfpyiyeehr")
    public fun defaultRouteOriginate(`value`: BooleanEnumProperty) {
        val toBeMapped = Either.ofRight<String, BooleanEnumProperty>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultRouteOriginate = mapped
    }

    /**
     * @param value BGP Ipv4 ListenRange.
     */
    @JvmName("ptyeyvmmudnmjmwb")
    public suspend fun ipv4ListenRangePrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4ListenRangePrefixes = mapped
    }

    /**
     * @param values BGP Ipv4 ListenRange.
     */
    @JvmName("qvyduiayuhggqhga")
    public suspend fun ipv4ListenRangePrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv4ListenRangePrefixes = mapped
    }

    /**
     * @param value List with stringified ipv4NeighborAddresses.
     */
    @JvmName("qakrrpmhibmeolif")
    public suspend fun ipv4NeighborAddress(`value`: List<NeighborAddressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4NeighborAddress = mapped
    }

    /**
     * @param argument List with stringified ipv4NeighborAddresses.
     */
    @JvmName("gqbqtlvegkukxcxx")
    public suspend
    fun ipv4NeighborAddress(argument: List<suspend NeighborAddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NeighborAddressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipv4NeighborAddress = mapped
    }

    /**
     * @param argument List with stringified ipv4NeighborAddresses.
     */
    @JvmName("lotjtgdmkrouwcek")
    public suspend fun ipv4NeighborAddress(
        vararg
        argument: suspend NeighborAddressArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NeighborAddressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipv4NeighborAddress = mapped
    }

    /**
     * @param argument List with stringified ipv4NeighborAddresses.
     */
    @JvmName("wltxqbuveulotsyr")
    public suspend fun ipv4NeighborAddress(argument: suspend NeighborAddressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NeighborAddressArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipv4NeighborAddress = mapped
    }

    /**
     * @param values List with stringified ipv4NeighborAddresses.
     */
    @JvmName("pbwqrcajjrjhybic")
    public suspend fun ipv4NeighborAddress(vararg values: NeighborAddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv4NeighborAddress = mapped
    }

    /**
     * @param value BGP Ipv6 ListenRange.
     */
    @JvmName("cbdmxmxhgjnvluwb")
    public suspend fun ipv6ListenRangePrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6ListenRangePrefixes = mapped
    }

    /**
     * @param values BGP Ipv6 ListenRange.
     */
    @JvmName("pixnxbhlotkywlde")
    public suspend fun ipv6ListenRangePrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6ListenRangePrefixes = mapped
    }

    /**
     * @param value List with stringified IPv6 Neighbor Address.
     */
    @JvmName("vowhsmdprwtmknil")
    public suspend fun ipv6NeighborAddress(`value`: List<NeighborAddressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6NeighborAddress = mapped
    }

    /**
     * @param argument List with stringified IPv6 Neighbor Address.
     */
    @JvmName("ijhaypfpyktsoeph")
    public suspend
    fun ipv6NeighborAddress(argument: List<suspend NeighborAddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NeighborAddressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipv6NeighborAddress = mapped
    }

    /**
     * @param argument List with stringified IPv6 Neighbor Address.
     */
    @JvmName("rdldaipsygnabwof")
    public suspend fun ipv6NeighborAddress(
        vararg
        argument: suspend NeighborAddressArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NeighborAddressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipv6NeighborAddress = mapped
    }

    /**
     * @param argument List with stringified IPv6 Neighbor Address.
     */
    @JvmName("wwyailddxynqgcro")
    public suspend fun ipv6NeighborAddress(argument: suspend NeighborAddressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NeighborAddressArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipv6NeighborAddress = mapped
    }

    /**
     * @param values List with stringified IPv6 Neighbor Address.
     */
    @JvmName("eppbxfxvvnuulest")
    public suspend fun ipv6NeighborAddress(vararg values: NeighborAddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6NeighborAddress = mapped
    }

    /**
     * @param value Peer ASN. Example: 65047.
     */
    @JvmName("hrkuinhgujwduimu")
    public suspend fun peerASN(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peerASN = mapped
    }

    internal fun build(): BgpConfigurationArgs = BgpConfigurationArgs(
        allowAS = allowAS,
        allowASOverride = allowASOverride,
        `annotation` = `annotation`,
        defaultRouteOriginate = defaultRouteOriginate,
        ipv4ListenRangePrefixes = ipv4ListenRangePrefixes,
        ipv4NeighborAddress = ipv4NeighborAddress,
        ipv6ListenRangePrefixes = ipv6ListenRangePrefixes,
        ipv6NeighborAddress = ipv6NeighborAddress,
        peerASN = peerASN ?: throw PulumiNullFieldException("peerASN"),
    )
}
