@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetIpCommunityPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipCommunityName Name of the IP Community.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetIpCommunityPlainArgs(
    public val ipCommunityName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetIpCommunityPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.GetIpCommunityPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetIpCommunityPlainArgs.builder()
            .ipCommunityName(ipCommunityName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpCommunityPlainArgs].
 */
@PulumiTagMarker
public class GetIpCommunityPlainArgsBuilder internal constructor() {
    private var ipCommunityName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the IP Community.
     */
    @JvmName("brgosxkkocpmrmpr")
    public suspend fun ipCommunityName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ipCommunityName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hfwxquyxpvpvjolc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIpCommunityPlainArgs = GetIpCommunityPlainArgs(
        ipCommunityName = ipCommunityName ?: throw PulumiNullFieldException("ipCommunityName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
