@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetIpExtendedCommunityPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipExtendedCommunityName Name of the IP Extended Community
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetIpExtendedCommunityPlainArgs(
    public val ipExtendedCommunityName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetIpExtendedCommunityPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.GetIpExtendedCommunityPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetIpExtendedCommunityPlainArgs.builder()
            .ipExtendedCommunityName(ipExtendedCommunityName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpExtendedCommunityPlainArgs].
 */
@PulumiTagMarker
public class GetIpExtendedCommunityPlainArgsBuilder internal constructor() {
    private var ipExtendedCommunityName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the IP Extended Community
     */
    @JvmName("vgwpgbhnpscxdspk")
    public suspend fun ipExtendedCommunityName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ipExtendedCommunityName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rgltoelgcwqrngvv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIpExtendedCommunityPlainArgs = GetIpExtendedCommunityPlainArgs(
        ipExtendedCommunityName = ipExtendedCommunityName ?: throw
            PulumiNullFieldException("ipExtendedCommunityName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
