@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetRoutePolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property routePolicyName Name of the Route Policy
 */
public data class GetRoutePolicyPlainArgs(
    public val resourceGroupName: String,
    public val routePolicyName: String,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetRoutePolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.GetRoutePolicyPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetRoutePolicyPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .routePolicyName(routePolicyName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRoutePolicyPlainArgs].
 */
@PulumiTagMarker
public class GetRoutePolicyPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var routePolicyName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rjmitcfffwkvjeiv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the Route Policy
     */
    @JvmName("sdcuimbcqrlbkhfe")
    public suspend fun routePolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.routePolicyName = mapped
    }

    internal fun build(): GetRoutePolicyPlainArgs = GetRoutePolicyPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        routePolicyName = routePolicyName ?: throw PulumiNullFieldException("routePolicyName"),
    )
}
