@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.IpPrefixPropertiesIpPrefixRulesArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.CommunityActionTypes
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.Condition
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property action Action to be taken on the configuration. Example: Permit | Deny.
 * @property condition Specify prefix-list bounds.
 * @property networkPrefix Network Prefix specifying IPv4/IPv6 packets to be permitted or denied. Example: 1.1.1.0/24 | 3FFE:FFFF:0:CD30::/126
 * @property sequenceNumber Sequence to insert to/delete from existing route. Prefix lists are evaluated starting with the lowest sequence number and continue down the list until a match is made. Once a match is made, the permit or deny statement is applied to that network and the rest of the list is ignored.
 * @property subnetMaskLength SubnetMaskLength gives the minimum NetworkPrefix length to be matched.Possible values for IPv4 are 1 - 32. Possible values of IPv6 are 1 - 128.
 */
public data class IpPrefixPropertiesIpPrefixRulesArgs(
    public val action: Output<Either<String, CommunityActionTypes>>,
    public val condition: Output<Either<String, Condition>>? = null,
    public val networkPrefix: Output<String>,
    public val sequenceNumber: Output<Double>,
    public val subnetMaskLength: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.IpPrefixPropertiesIpPrefixRulesArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.IpPrefixPropertiesIpPrefixRulesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.IpPrefixPropertiesIpPrefixRulesArgs.builder()
            .action(
                action.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .condition(
                condition?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkPrefix(networkPrefix.applyValue({ args0 -> args0 }))
            .sequenceNumber(sequenceNumber.applyValue({ args0 -> args0 }))
            .subnetMaskLength(subnetMaskLength?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpPrefixPropertiesIpPrefixRulesArgs].
 */
@PulumiTagMarker
public class IpPrefixPropertiesIpPrefixRulesArgsBuilder internal constructor() {
    private var action: Output<Either<String, CommunityActionTypes>>? = null

    private var condition: Output<Either<String, Condition>>? = null

    private var networkPrefix: Output<String>? = null

    private var sequenceNumber: Output<Double>? = null

    private var subnetMaskLength: Output<Int>? = null

    /**
     * @param value Action to be taken on the configuration. Example: Permit | Deny.
     */
    @JvmName("ijebvyqadydecgoo")
    public suspend fun action(`value`: Output<Either<String, CommunityActionTypes>>) {
        this.action = value
    }

    /**
     * @param value Specify prefix-list bounds.
     */
    @JvmName("uvmcoybyqlxkuwxt")
    public suspend fun condition(`value`: Output<Either<String, Condition>>) {
        this.condition = value
    }

    /**
     * @param value Network Prefix specifying IPv4/IPv6 packets to be permitted or denied. Example: 1.1.1.0/24 | 3FFE:FFFF:0:CD30::/126
     */
    @JvmName("vwsehhupbkquiwri")
    public suspend fun networkPrefix(`value`: Output<String>) {
        this.networkPrefix = value
    }

    /**
     * @param value Sequence to insert to/delete from existing route. Prefix lists are evaluated starting with the lowest sequence number and continue down the list until a match is made. Once a match is made, the permit or deny statement is applied to that network and the rest of the list is ignored.
     */
    @JvmName("wturvewjytqctgpr")
    public suspend fun sequenceNumber(`value`: Output<Double>) {
        this.sequenceNumber = value
    }

    /**
     * @param value SubnetMaskLength gives the minimum NetworkPrefix length to be matched.Possible values for IPv4 are 1 - 32. Possible values of IPv6 are 1 - 128.
     */
    @JvmName("rkhnefmshkaevdvw")
    public suspend fun subnetMaskLength(`value`: Output<Int>) {
        this.subnetMaskLength = value
    }

    /**
     * @param value Action to be taken on the configuration. Example: Permit | Deny.
     */
    @JvmName("amnmbpxqhxhroynv")
    public suspend fun action(`value`: Either<String, CommunityActionTypes>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Action to be taken on the configuration. Example: Permit | Deny.
     */
    @JvmName("ajalyqvnoyvggfkn")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CommunityActionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Action to be taken on the configuration. Example: Permit | Deny.
     */
    @JvmName("odftpjnthmxalhvi")
    public fun action(`value`: CommunityActionTypes) {
        val toBeMapped = Either.ofRight<String, CommunityActionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Specify prefix-list bounds.
     */
    @JvmName("qgsakakpflscpcyb")
    public suspend fun condition(`value`: Either<String, Condition>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value Specify prefix-list bounds.
     */
    @JvmName("aralqyqrtmkxxxtx")
    public fun condition(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Condition>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value Specify prefix-list bounds.
     */
    @JvmName("qovedvwjswwbykgh")
    public fun condition(`value`: Condition) {
        val toBeMapped = Either.ofRight<String, Condition>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value Network Prefix specifying IPv4/IPv6 packets to be permitted or denied. Example: 1.1.1.0/24 | 3FFE:FFFF:0:CD30::/126
     */
    @JvmName("sotmjdrffmntnuss")
    public suspend fun networkPrefix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkPrefix = mapped
    }

    /**
     * @param value Sequence to insert to/delete from existing route. Prefix lists are evaluated starting with the lowest sequence number and continue down the list until a match is made. Once a match is made, the permit or deny statement is applied to that network and the rest of the list is ignored.
     */
    @JvmName("dynattdosrjpcvlj")
    public suspend fun sequenceNumber(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sequenceNumber = mapped
    }

    /**
     * @param value SubnetMaskLength gives the minimum NetworkPrefix length to be matched.Possible values for IPv4 are 1 - 32. Possible values of IPv6 are 1 - 128.
     */
    @JvmName("tmjrhqicqmvkppyt")
    public suspend fun subnetMaskLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetMaskLength = mapped
    }

    internal fun build(): IpPrefixPropertiesIpPrefixRulesArgs = IpPrefixPropertiesIpPrefixRulesArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        condition = condition,
        networkPrefix = networkPrefix ?: throw PulumiNullFieldException("networkPrefix"),
        sequenceNumber = sequenceNumber ?: throw PulumiNullFieldException("sequenceNumber"),
        subnetMaskLength = subnetMaskLength,
    )
}
