@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Connected Subnet RoutePolicy
 * @property exportRoutePolicyId exportRoutePolicyId value.
 */
public data class L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs(
    public val exportRoutePolicyId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs.builder()
            .exportRoutePolicyId(exportRoutePolicyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs].
 */
@PulumiTagMarker
public class L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgsBuilder internal
constructor() {
    private var exportRoutePolicyId: Output<String>? = null

    /**
     * @param value exportRoutePolicyId value.
     */
    @JvmName("nqcfqugjanrhusre")
    public suspend fun exportRoutePolicyId(`value`: Output<String>) {
        this.exportRoutePolicyId = value
    }

    /**
     * @param value exportRoutePolicyId value.
     */
    @JvmName("vpgccwfgyvvnfgij")
    public suspend fun exportRoutePolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportRoutePolicyId = mapped
    }

    internal fun build(): L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs =
        L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs(
            exportRoutePolicyId = exportRoutePolicyId,
        )
}
