@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.ManagedResourceGroupConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed Resource Group configuration properties.
 * @property location Managed resource group location.
 * @property name The NFC service will be hosted in a Managed resource group.
 */
public data class ManagedResourceGroupConfigurationArgs(
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.ManagedResourceGroupConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.ManagedResourceGroupConfigurationArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.ManagedResourceGroupConfigurationArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedResourceGroupConfigurationArgs].
 */
@PulumiTagMarker
public class ManagedResourceGroupConfigurationArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Managed resource group location.
     */
    @JvmName("eoesionwtkajiycn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The NFC service will be hosted in a Managed resource group.
     */
    @JvmName("ghdejlultkawuiim")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Managed resource group location.
     */
    @JvmName("sjuakftcawjnktqi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The NFC service will be hosted in a Managed resource group.
     */
    @JvmName("gyarfsxfbtbuwwwh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ManagedResourceGroupConfigurationArgs =
        ManagedResourceGroupConfigurationArgs(
            location = location,
            name = name,
        )
}
