@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapRuleMatchConfigurationArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.IPAddressType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the match configuration that are supported to filter the traffic.
 * @property actions List of actions that need to be performed for the matched conditions.
 * @property ipAddressType Type of IP Address. IPv4 or IPv6
 * @property matchConditions List of the match conditions.
 * @property matchConfigurationName The name of the match configuration.
 * @property sequenceNumber Sequence Number of the match configuration..
 */
public data class NetworkTapRuleMatchConfigurationArgs(
    public val actions: Output<List<NetworkTapRuleActionArgs>>? = null,
    public val ipAddressType: Output<Either<String, IPAddressType>>? = null,
    public val matchConditions: Output<List<NetworkTapRuleMatchConditionArgs>>? = null,
    public val matchConfigurationName: Output<String>? = null,
    public val sequenceNumber: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapRuleMatchConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapRuleMatchConfigurationArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.NetworkTapRuleMatchConfigurationArgs.builder()
            .actions(
                actions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ipAddressType(
                ipAddressType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .matchConditions(
                matchConditions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .matchConfigurationName(matchConfigurationName?.applyValue({ args0 -> args0 }))
            .sequenceNumber(sequenceNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkTapRuleMatchConfigurationArgs].
 */
@PulumiTagMarker
public class NetworkTapRuleMatchConfigurationArgsBuilder internal constructor() {
    private var actions: Output<List<NetworkTapRuleActionArgs>>? = null

    private var ipAddressType: Output<Either<String, IPAddressType>>? = null

    private var matchConditions: Output<List<NetworkTapRuleMatchConditionArgs>>? = null

    private var matchConfigurationName: Output<String>? = null

    private var sequenceNumber: Output<Double>? = null

    /**
     * @param value List of actions that need to be performed for the matched conditions.
     */
    @JvmName("cnhcsowifdjiviuw")
    public suspend fun actions(`value`: Output<List<NetworkTapRuleActionArgs>>) {
        this.actions = value
    }

    @JvmName("fopnmohjelcmeoyd")
    public suspend fun actions(vararg values: Output<NetworkTapRuleActionArgs>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values List of actions that need to be performed for the matched conditions.
     */
    @JvmName("reimwihpdktevenr")
    public suspend fun actions(values: List<Output<NetworkTapRuleActionArgs>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value Type of IP Address. IPv4 or IPv6
     */
    @JvmName("qpktpebydvfvbgoy")
    public suspend fun ipAddressType(`value`: Output<Either<String, IPAddressType>>) {
        this.ipAddressType = value
    }

    /**
     * @param value List of the match conditions.
     */
    @JvmName("pcjcpniivthpcuyt")
    public suspend fun matchConditions(`value`: Output<List<NetworkTapRuleMatchConditionArgs>>) {
        this.matchConditions = value
    }

    @JvmName("hdlamfrytcmwyatx")
    public suspend fun matchConditions(vararg values: Output<NetworkTapRuleMatchConditionArgs>) {
        this.matchConditions = Output.all(values.asList())
    }

    /**
     * @param values List of the match conditions.
     */
    @JvmName("pebgdoikhrdwvlal")
    public suspend fun matchConditions(values: List<Output<NetworkTapRuleMatchConditionArgs>>) {
        this.matchConditions = Output.all(values)
    }

    /**
     * @param value The name of the match configuration.
     */
    @JvmName("rvkqhlskxkgnoxex")
    public suspend fun matchConfigurationName(`value`: Output<String>) {
        this.matchConfigurationName = value
    }

    /**
     * @param value Sequence Number of the match configuration..
     */
    @JvmName("hagvdundydxdgdwj")
    public suspend fun sequenceNumber(`value`: Output<Double>) {
        this.sequenceNumber = value
    }

    /**
     * @param value List of actions that need to be performed for the matched conditions.
     */
    @JvmName("bfkqawyfegpjaenf")
    public suspend fun actions(`value`: List<NetworkTapRuleActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument List of actions that need to be performed for the matched conditions.
     */
    @JvmName("djgnuvbnxmfarqli")
    public suspend fun actions(argument: List<suspend NetworkTapRuleActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkTapRuleActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument List of actions that need to be performed for the matched conditions.
     */
    @JvmName("ldtqwkcckrxawtkb")
    public suspend fun actions(vararg argument: suspend NetworkTapRuleActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NetworkTapRuleActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument List of actions that need to be performed for the matched conditions.
     */
    @JvmName("lrkvnyfjjyketdkl")
    public suspend fun actions(argument: suspend NetworkTapRuleActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NetworkTapRuleActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param values List of actions that need to be performed for the matched conditions.
     */
    @JvmName("cnnomrmfxfrdmnlb")
    public suspend fun actions(vararg values: NetworkTapRuleActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value Type of IP Address. IPv4 or IPv6
     */
    @JvmName("kghwuwfwwhoqbpoy")
    public suspend fun ipAddressType(`value`: Either<String, IPAddressType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value Type of IP Address. IPv4 or IPv6
     */
    @JvmName("pdgdxsqwtrcfodws")
    public fun ipAddressType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAddressType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value Type of IP Address. IPv4 or IPv6
     */
    @JvmName("srpobnmfmjkrgdmm")
    public fun ipAddressType(`value`: IPAddressType) {
        val toBeMapped = Either.ofRight<String, IPAddressType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value List of the match conditions.
     */
    @JvmName("aoorfcseibbxsqdc")
    public suspend fun matchConditions(`value`: List<NetworkTapRuleMatchConditionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchConditions = mapped
    }

    /**
     * @param argument List of the match conditions.
     */
    @JvmName("rvojtevgqenuogvt")
    public suspend
    fun matchConditions(argument: List<suspend NetworkTapRuleMatchConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkTapRuleMatchConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param argument List of the match conditions.
     */
    @JvmName("cvcshboncklpqwcp")
    public suspend fun matchConditions(
        vararg
        argument: suspend NetworkTapRuleMatchConditionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NetworkTapRuleMatchConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param argument List of the match conditions.
     */
    @JvmName("ixnsqmrmdosqqpkc")
    public suspend
    fun matchConditions(argument: suspend NetworkTapRuleMatchConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NetworkTapRuleMatchConditionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.matchConditions = mapped
    }

    /**
     * @param values List of the match conditions.
     */
    @JvmName("nlmgnaphltbrwtui")
    public suspend fun matchConditions(vararg values: NetworkTapRuleMatchConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchConditions = mapped
    }

    /**
     * @param value The name of the match configuration.
     */
    @JvmName("wjuvpjhtqoeltgpj")
    public suspend fun matchConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchConfigurationName = mapped
    }

    /**
     * @param value Sequence Number of the match configuration..
     */
    @JvmName("icieyiaeqlkxyfde")
    public suspend fun sequenceNumber(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sequenceNumber = mapped
    }

    internal fun build(): NetworkTapRuleMatchConfigurationArgs = NetworkTapRuleMatchConfigurationArgs(
        actions = actions,
        ipAddressType = ipAddressType,
        matchConditions = matchConditions,
        matchConfigurationName = matchConfigurationName,
        sequenceNumber = sequenceNumber,
    )
}
