@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.StatementConditionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Route policy statement condition properties.
 * @property ipCommunityIds List of IP Community resource IDs.
 * @property ipExtendedCommunityIds List of IP Extended Community resource IDs.
 * @property ipPrefixId Arm Resource Id of IpPrefix.
 */
public data class StatementConditionPropertiesArgs(
    public val ipCommunityIds: Output<List<String>>? = null,
    public val ipExtendedCommunityIds: Output<List<String>>? = null,
    public val ipPrefixId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.StatementConditionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.StatementConditionPropertiesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.StatementConditionPropertiesArgs.builder()
            .ipCommunityIds(ipCommunityIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipExtendedCommunityIds(
                ipExtendedCommunityIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .ipPrefixId(ipPrefixId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StatementConditionPropertiesArgs].
 */
@PulumiTagMarker
public class StatementConditionPropertiesArgsBuilder internal constructor() {
    private var ipCommunityIds: Output<List<String>>? = null

    private var ipExtendedCommunityIds: Output<List<String>>? = null

    private var ipPrefixId: Output<String>? = null

    /**
     * @param value List of IP Community resource IDs.
     */
    @JvmName("kedkcjucuhdfdrhu")
    public suspend fun ipCommunityIds(`value`: Output<List<String>>) {
        this.ipCommunityIds = value
    }

    @JvmName("prcemqswqiahcegc")
    public suspend fun ipCommunityIds(vararg values: Output<String>) {
        this.ipCommunityIds = Output.all(values.asList())
    }

    /**
     * @param values List of IP Community resource IDs.
     */
    @JvmName("deywbaxscwvqovjl")
    public suspend fun ipCommunityIds(values: List<Output<String>>) {
        this.ipCommunityIds = Output.all(values)
    }

    /**
     * @param value List of IP Extended Community resource IDs.
     */
    @JvmName("mejhnkmbxslrkhlk")
    public suspend fun ipExtendedCommunityIds(`value`: Output<List<String>>) {
        this.ipExtendedCommunityIds = value
    }

    @JvmName("oenmlclfvnktupua")
    public suspend fun ipExtendedCommunityIds(vararg values: Output<String>) {
        this.ipExtendedCommunityIds = Output.all(values.asList())
    }

    /**
     * @param values List of IP Extended Community resource IDs.
     */
    @JvmName("xjmoysdpsvbidkms")
    public suspend fun ipExtendedCommunityIds(values: List<Output<String>>) {
        this.ipExtendedCommunityIds = Output.all(values)
    }

    /**
     * @param value Arm Resource Id of IpPrefix.
     */
    @JvmName("ckiujxfilgxuswnk")
    public suspend fun ipPrefixId(`value`: Output<String>) {
        this.ipPrefixId = value
    }

    /**
     * @param value List of IP Community resource IDs.
     */
    @JvmName("xsxvaafsxxlfaenp")
    public suspend fun ipCommunityIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipCommunityIds = mapped
    }

    /**
     * @param values List of IP Community resource IDs.
     */
    @JvmName("lcmxkhssjnhwsctu")
    public suspend fun ipCommunityIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipCommunityIds = mapped
    }

    /**
     * @param value List of IP Extended Community resource IDs.
     */
    @JvmName("vdwrougksxekijaq")
    public suspend fun ipExtendedCommunityIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipExtendedCommunityIds = mapped
    }

    /**
     * @param values List of IP Extended Community resource IDs.
     */
    @JvmName("myrhlsxeppmebkjn")
    public suspend fun ipExtendedCommunityIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipExtendedCommunityIds = mapped
    }

    /**
     * @param value Arm Resource Id of IpPrefix.
     */
    @JvmName("gyrxvqkgfmwjfsss")
    public suspend fun ipPrefixId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipPrefixId = mapped
    }

    internal fun build(): StatementConditionPropertiesArgs = StatementConditionPropertiesArgs(
        ipCommunityIds = ipCommunityIds,
        ipExtendedCommunityIds = ipExtendedCommunityIds,
        ipPrefixId = ipPrefixId,
    )
}
