@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.StaticRouteConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * staticRouteConfiguration model.
 * @property ipv4Routes List with object IPv4Routes.
 * @property ipv6Routes List with object IPv6Routes.
 */
public data class StaticRouteConfigurationArgs(
    public val ipv4Routes: Output<List<StaticRoutePropertiesArgs>>? = null,
    public val ipv6Routes: Output<List<StaticRoutePropertiesArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.StaticRouteConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.StaticRouteConfigurationArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.StaticRouteConfigurationArgs.builder()
            .ipv4Routes(
                ipv4Routes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ipv6Routes(
                ipv6Routes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [StaticRouteConfigurationArgs].
 */
@PulumiTagMarker
public class StaticRouteConfigurationArgsBuilder internal constructor() {
    private var ipv4Routes: Output<List<StaticRoutePropertiesArgs>>? = null

    private var ipv6Routes: Output<List<StaticRoutePropertiesArgs>>? = null

    /**
     * @param value List with object IPv4Routes.
     */
    @JvmName("kfcbmoycmlxpetkj")
    public suspend fun ipv4Routes(`value`: Output<List<StaticRoutePropertiesArgs>>) {
        this.ipv4Routes = value
    }

    @JvmName("pisevakljkugcqxh")
    public suspend fun ipv4Routes(vararg values: Output<StaticRoutePropertiesArgs>) {
        this.ipv4Routes = Output.all(values.asList())
    }

    /**
     * @param values List with object IPv4Routes.
     */
    @JvmName("hcslymaiknpuawsl")
    public suspend fun ipv4Routes(values: List<Output<StaticRoutePropertiesArgs>>) {
        this.ipv4Routes = Output.all(values)
    }

    /**
     * @param value List with object IPv6Routes.
     */
    @JvmName("qfeyphalecnfgdfy")
    public suspend fun ipv6Routes(`value`: Output<List<StaticRoutePropertiesArgs>>) {
        this.ipv6Routes = value
    }

    @JvmName("tqdnjurflgkugcjj")
    public suspend fun ipv6Routes(vararg values: Output<StaticRoutePropertiesArgs>) {
        this.ipv6Routes = Output.all(values.asList())
    }

    /**
     * @param values List with object IPv6Routes.
     */
    @JvmName("moxgjwxfmjwxmtot")
    public suspend fun ipv6Routes(values: List<Output<StaticRoutePropertiesArgs>>) {
        this.ipv6Routes = Output.all(values)
    }

    /**
     * @param value List with object IPv4Routes.
     */
    @JvmName("vftjrconhbcdbgyv")
    public suspend fun ipv4Routes(`value`: List<StaticRoutePropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4Routes = mapped
    }

    /**
     * @param argument List with object IPv4Routes.
     */
    @JvmName("lopihfxbsidaemtj")
    public suspend
    fun ipv4Routes(argument: List<suspend StaticRoutePropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StaticRoutePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipv4Routes = mapped
    }

    /**
     * @param argument List with object IPv4Routes.
     */
    @JvmName("ptsetwuodtagamfg")
    public suspend fun ipv4Routes(
        vararg
        argument: suspend StaticRoutePropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StaticRoutePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipv4Routes = mapped
    }

    /**
     * @param argument List with object IPv4Routes.
     */
    @JvmName("ksbbsyrxfsgousop")
    public suspend fun ipv4Routes(argument: suspend StaticRoutePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StaticRoutePropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipv4Routes = mapped
    }

    /**
     * @param values List with object IPv4Routes.
     */
    @JvmName("hlgcjdgnvooqepdq")
    public suspend fun ipv4Routes(vararg values: StaticRoutePropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv4Routes = mapped
    }

    /**
     * @param value List with object IPv6Routes.
     */
    @JvmName("qkhctircixaemkuc")
    public suspend fun ipv6Routes(`value`: List<StaticRoutePropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Routes = mapped
    }

    /**
     * @param argument List with object IPv6Routes.
     */
    @JvmName("ksygvnoepkoyrwou")
    public suspend
    fun ipv6Routes(argument: List<suspend StaticRoutePropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StaticRoutePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipv6Routes = mapped
    }

    /**
     * @param argument List with object IPv6Routes.
     */
    @JvmName("rmawqnolwvdrgvij")
    public suspend fun ipv6Routes(
        vararg
        argument: suspend StaticRoutePropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StaticRoutePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipv6Routes = mapped
    }

    /**
     * @param argument List with object IPv6Routes.
     */
    @JvmName("etghygdlbhxfeidi")
    public suspend fun ipv6Routes(argument: suspend StaticRoutePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StaticRoutePropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipv6Routes = mapped
    }

    /**
     * @param values List with object IPv6Routes.
     */
    @JvmName("cxvqrruwhlolmhbk")
    public suspend fun ipv6Routes(vararg values: StaticRoutePropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6Routes = mapped
    }

    internal fun build(): StaticRouteConfigurationArgs = StaticRouteConfigurationArgs(
        ipv4Routes = ipv4Routes,
        ipv6Routes = ipv6Routes,
    )
}
