@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.VlanMatchConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The vlan match conditions that need to be matched.
 * @property innerVlans List of inner vlans that need to be matched.
 * @property vlanGroupNames List of vlan group names that need to be matched.
 * @property vlans List of vlans that need to be matched.
 */
public data class VlanMatchConditionArgs(
    public val innerVlans: Output<List<String>>? = null,
    public val vlanGroupNames: Output<List<String>>? = null,
    public val vlans: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.VlanMatchConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.VlanMatchConditionArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.VlanMatchConditionArgs.builder()
            .innerVlans(innerVlans?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vlanGroupNames(vlanGroupNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vlans(vlans?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [VlanMatchConditionArgs].
 */
@PulumiTagMarker
public class VlanMatchConditionArgsBuilder internal constructor() {
    private var innerVlans: Output<List<String>>? = null

    private var vlanGroupNames: Output<List<String>>? = null

    private var vlans: Output<List<String>>? = null

    /**
     * @param value List of inner vlans that need to be matched.
     */
    @JvmName("oovaapkfgsllddef")
    public suspend fun innerVlans(`value`: Output<List<String>>) {
        this.innerVlans = value
    }

    @JvmName("lovtxftoajugqmxe")
    public suspend fun innerVlans(vararg values: Output<String>) {
        this.innerVlans = Output.all(values.asList())
    }

    /**
     * @param values List of inner vlans that need to be matched.
     */
    @JvmName("hodrweqbamdxgmiy")
    public suspend fun innerVlans(values: List<Output<String>>) {
        this.innerVlans = Output.all(values)
    }

    /**
     * @param value List of vlan group names that need to be matched.
     */
    @JvmName("jbmyoprysminoaux")
    public suspend fun vlanGroupNames(`value`: Output<List<String>>) {
        this.vlanGroupNames = value
    }

    @JvmName("osijfljtacubtbji")
    public suspend fun vlanGroupNames(vararg values: Output<String>) {
        this.vlanGroupNames = Output.all(values.asList())
    }

    /**
     * @param values List of vlan group names that need to be matched.
     */
    @JvmName("wmmtxwtmnwnlewil")
    public suspend fun vlanGroupNames(values: List<Output<String>>) {
        this.vlanGroupNames = Output.all(values)
    }

    /**
     * @param value List of vlans that need to be matched.
     */
    @JvmName("qgnkbqpybgfvhwkm")
    public suspend fun vlans(`value`: Output<List<String>>) {
        this.vlans = value
    }

    @JvmName("wwnmejbwxbibmjql")
    public suspend fun vlans(vararg values: Output<String>) {
        this.vlans = Output.all(values.asList())
    }

    /**
     * @param values List of vlans that need to be matched.
     */
    @JvmName("nqfeahoudbuirjyc")
    public suspend fun vlans(values: List<Output<String>>) {
        this.vlans = Output.all(values)
    }

    /**
     * @param value List of inner vlans that need to be matched.
     */
    @JvmName("kaxwspmixwuppowq")
    public suspend fun innerVlans(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.innerVlans = mapped
    }

    /**
     * @param values List of inner vlans that need to be matched.
     */
    @JvmName("yeexigkuuwbdmwjk")
    public suspend fun innerVlans(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.innerVlans = mapped
    }

    /**
     * @param value List of vlan group names that need to be matched.
     */
    @JvmName("cyqmfsqmtbksslmu")
    public suspend fun vlanGroupNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlanGroupNames = mapped
    }

    /**
     * @param values List of vlan group names that need to be matched.
     */
    @JvmName("egnvtpdehncmfete")
    public suspend fun vlanGroupNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vlanGroupNames = mapped
    }

    /**
     * @param value List of vlans that need to be matched.
     */
    @JvmName("fyfyyjbvhdkmxnjr")
    public suspend fun vlans(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlans = mapped
    }

    /**
     * @param values List of vlans that need to be matched.
     */
    @JvmName("quyrpojphlvjclmi")
    public suspend fun vlans(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vlans = mapped
    }

    internal fun build(): VlanMatchConditionArgs = VlanMatchConditionArgs(
        innerVlans = innerVlans,
        vlanGroupNames = vlanGroupNames,
        vlans = vlans,
    )
}
