@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The Internet Gateway resource definition.
 * @property annotation Switch configuration description.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property internetGatewayRuleId ARM Resource ID of the Internet Gateway Rule.
 * @property ipv4Address IPv4 Address of Internet Gateway.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property networkFabricControllerId ARM Resource ID of the Network Fabric Controller.
 * @property port Port number of Internet Gateway.
 * @property provisioningState Provisioning state of resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetInternetGatewayResult(
    public val `annotation`: String? = null,
    public val id: String,
    public val internetGatewayRuleId: String? = null,
    public val ipv4Address: String,
    public val location: String,
    public val name: String,
    public val networkFabricControllerId: String,
    public val port: Int,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetInternetGatewayResult):
            GetInternetGatewayResult = GetInternetGatewayResult(
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            internetGatewayRuleId = javaType.internetGatewayRuleId().map({ args0 -> args0 }).orElse(null),
            ipv4Address = javaType.ipv4Address(),
            location = javaType.location(),
            name = javaType.name(),
            networkFabricControllerId = javaType.networkFabricControllerId(),
            port = javaType.port(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
