@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Get Device status response properties.
 * @property operationalStatus Primary or Secondary power end.
 * @property powerCycleState On or Off power cycle state.
 * @property serialNumber The serial number of the device
 */
public data class GetNetworkDeviceStatusResult(
    public val operationalStatus: String,
    public val powerCycleState: String,
    public val serialNumber: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetNetworkDeviceStatusResult):
            GetNetworkDeviceStatusResult = GetNetworkDeviceStatusResult(
            operationalStatus = javaType.operationalStatus(),
            powerCycleState = javaType.powerCycleState(),
            serialNumber = javaType.serialNumber(),
        )
    }
}
