@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The NetworkRack resource definition.
 * @property annotation Switch configuration description.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property networkDevices List of network device ARM resource ids.
 * @property networkFabricId Network Fabric ARM resource id.
 * @property networkRackSku Network Rack SKU name.
 * @property provisioningState Gets the provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetNetworkRackResult(
    public val `annotation`: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val networkDevices: List<String>,
    public val networkFabricId: String,
    public val networkRackSku: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetNetworkRackResult):
            GetNetworkRackResult = GetNetworkRackResult(
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            networkDevices = javaType.networkDevices().map({ args0 -> args0 }),
            networkFabricId = javaType.networkFabricId(),
            networkRackSku = javaType.networkRackSku(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
