@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * layer2Configuration
 * @property interfaces List of network device interfaces resource IDs.
 * @property mtu MTU of the packets between PE & CE.
 * @property portCount Number of ports connected between PE/CE. Maximum value depends on FabricSKU.
 */
public data class Layer2ConfigurationResponse(
    public val interfaces: List<String>,
    public val mtu: Int,
    public val portCount: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.Layer2ConfigurationResponse):
            Layer2ConfigurationResponse = Layer2ConfigurationResponse(
            interfaces = javaType.interfaces().map({ args0 -> args0 }),
            mtu = javaType.mtu(),
            portCount = javaType.portCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
