@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Neighbor Address properties.
 * @property address IP Address.
 * @property operationalState OperationalState of the NeighborAddress.
 */
public data class NeighborAddressResponse(
    public val address: String? = null,
    public val operationalState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.NeighborAddressResponse):
            NeighborAddressResponse = NeighborAddressResponse(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            operationalState = javaType.operationalState(),
        )
    }
}
