@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Port Group properties.
 * @property name The name of the port group.
 * @property ports List of the ports that need to be matched.
 */
public data class PortGroupPropertiesResponse(
    public val name: String? = null,
    public val ports: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.PortGroupPropertiesResponse):
            PortGroupPropertiesResponse = PortGroupPropertiesResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            ports = javaType.ports().map({ args0 -> args0 }),
        )
    }
}
