@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Route policy statement condition properties.
 * @property ipCommunityIds List of IP Community resource IDs.
 * @property ipExtendedCommunityIds List of IP Extended Community resource IDs.
 * @property ipPrefixId Arm Resource Id of IpPrefix.
 */
public data class StatementConditionPropertiesResponse(
    public val ipCommunityIds: List<String>? = null,
    public val ipExtendedCommunityIds: List<String>? = null,
    public val ipPrefixId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.StatementConditionPropertiesResponse):
            StatementConditionPropertiesResponse = StatementConditionPropertiesResponse(
            ipCommunityIds = javaType.ipCommunityIds().map({ args0 -> args0 }),
            ipExtendedCommunityIds = javaType.ipExtendedCommunityIds().map({ args0 -> args0 }),
            ipPrefixId = javaType.ipPrefixId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
