@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * staticRouteConfiguration model.
 * @property bfdConfiguration BFD configuration properties
 * @property ipv4Routes List with object IPv4Routes.
 * @property ipv6Routes List with object IPv6Routes.
 */
public data class StaticRouteConfigurationResponse(
    public val bfdConfiguration: BfdConfigurationResponse? = null,
    public val ipv4Routes: List<StaticRoutePropertiesResponse>? = null,
    public val ipv6Routes: List<StaticRoutePropertiesResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.StaticRouteConfigurationResponse):
            StaticRouteConfigurationResponse = StaticRouteConfigurationResponse(
            bfdConfiguration = javaType.bfdConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.BfdConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ipv4Routes = javaType.ipv4Routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.StaticRoutePropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            ipv6Routes = javaType.ipv6Routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.StaticRoutePropertiesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
