@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Static Route properties.
 * @property nextHop List of next hop IPv4 | IPv6 addresses.
 * @property prefix IPv4 | IPv6 Prefix.
 */
public data class StaticRoutePropertiesResponse(
    public val nextHop: List<String>,
    public val prefix: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.StaticRoutePropertiesResponse):
            StaticRoutePropertiesResponse = StaticRoutePropertiesResponse(
            nextHop = javaType.nextHop().map({ args0 -> args0 }),
            prefix = javaType.prefix(),
        )
    }
}
