@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin

import com.pulumi.azurenative.managedservices.kotlin.outputs.RegistrationAssignmentPropertiesResponse
import com.pulumi.azurenative.managedservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.managedservices.kotlin.outputs.RegistrationAssignmentPropertiesResponse.Companion.toKotlin as registrationAssignmentPropertiesResponseToKotlin
import com.pulumi.azurenative.managedservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [RegistrationAssignment].
 */
@PulumiTagMarker
public class RegistrationAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistrationAssignmentArgs = RegistrationAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistrationAssignmentArgsBuilder.() -> Unit) {
        val builder = RegistrationAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RegistrationAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.managedservices.RegistrationAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RegistrationAssignment(builtJavaResource)
    }
}

/**
 * The registration assignment.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2019-09-01.
 * ## Example Usage
 * ### Put Registration Assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registrationAssignment = new AzureNative.ManagedServices.RegistrationAssignment("registrationAssignment", new()
 *     {
 *         Properties = new AzureNative.ManagedServices.Inputs.RegistrationAssignmentPropertiesArgs
 *         {
 *             RegistrationDefinitionId = "/subscriptions/0afefe50-734e-4610-8a82-a144ahf49dea/providers/Microsoft.ManagedServices/registrationDefinitions/26c128c2-fefa-4340-9bb1-6e081c90ada2",
 *         },
 *         RegistrationAssignmentId = "26c128c2-fefa-4340-9bb1-6e081c90ada2",
 *         Scope = "subscription/0afefe50-734e-4610-8a82-a144ahf49dea",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managedservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managedservices.NewRegistrationAssignment(ctx, "registrationAssignment", &managedservices.RegistrationAssignmentArgs{
 * 			Properties: &managedservices.RegistrationAssignmentPropertiesArgs{
 * 				RegistrationDefinitionId: pulumi.String("/subscriptions/0afefe50-734e-4610-8a82-a144ahf49dea/providers/Microsoft.ManagedServices/registrationDefinitions/26c128c2-fefa-4340-9bb1-6e081c90ada2"),
 * 			},
 * 			RegistrationAssignmentId: pulumi.String("26c128c2-fefa-4340-9bb1-6e081c90ada2"),
 * 			Scope:                    pulumi.String("subscription/0afefe50-734e-4610-8a82-a144ahf49dea"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managedservices.RegistrationAssignment;
 * import com.pulumi.azurenative.managedservices.RegistrationAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registrationAssignment = new RegistrationAssignment("registrationAssignment", RegistrationAssignmentArgs.builder()
 *             .properties(Map.of("registrationDefinitionId", "/subscriptions/0afefe50-734e-4610-8a82-a144ahf49dea/providers/Microsoft.ManagedServices/registrationDefinitions/26c128c2-fefa-4340-9bb1-6e081c90ada2"))
 *             .registrationAssignmentId("26c128c2-fefa-4340-9bb1-6e081c90ada2")
 *             .scope("subscription/0afefe50-734e-4610-8a82-a144ahf49dea")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managedservices:RegistrationAssignment 484a7d5f-9729-4b87-bc9b-26610985a013 /{scope}/providers/Microsoft.ManagedServices/registrationAssignments/{registrationAssignmentId}
 * ```
 */
public class RegistrationAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.managedservices.RegistrationAssignment,
) : KotlinCustomResource(javaResource, RegistrationAssignmentMapper) {
    /**
     * The name of the registration assignment.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The properties of a registration assignment.
     */
    public val properties: Output<RegistrationAssignmentPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                registrationAssignmentPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The metadata for the registration assignment resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the Azure resource (Microsoft.ManagedServices/registrationAssignments).
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RegistrationAssignmentMapper : ResourceMapper<RegistrationAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managedservices.RegistrationAssignment::class == javaResource::class

    override fun map(javaResource: Resource): RegistrationAssignment =
        RegistrationAssignment(
            javaResource as
                com.pulumi.azurenative.managedservices.RegistrationAssignment,
        )
}

/**
 * @see [RegistrationAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistrationAssignment].
 */
public suspend fun registrationAssignment(
    name: String,
    block: suspend RegistrationAssignmentResourceBuilder.() -> Unit,
): RegistrationAssignment {
    val builder = RegistrationAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistrationAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registrationAssignment(name: String): RegistrationAssignment {
    val builder = RegistrationAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
