@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.inputs

import com.pulumi.azurenative.managedservices.inputs.JustInTimeAccessPolicyArgs.builder
import com.pulumi.azurenative.managedservices.kotlin.enums.MultiFactorAuthProvider
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Just-in-time access policy setting.
 * @property managedByTenantApprovers The list of managedByTenant approvers for the eligible authorization.
 * @property maximumActivationDuration The maximum access duration in ISO 8601 format for just-in-time access requests.
 * @property multiFactorAuthProvider The multi-factor authorization provider to be used for just-in-time access requests.
 */
public data class JustInTimeAccessPolicyArgs(
    public val managedByTenantApprovers: Output<List<EligibleApproverArgs>>? = null,
    public val maximumActivationDuration: Output<String>? = null,
    public val multiFactorAuthProvider: Output<Either<String, MultiFactorAuthProvider>>,
) : ConvertibleToJava<com.pulumi.azurenative.managedservices.inputs.JustInTimeAccessPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.managedservices.inputs.JustInTimeAccessPolicyArgs =
        com.pulumi.azurenative.managedservices.inputs.JustInTimeAccessPolicyArgs.builder()
            .managedByTenantApprovers(
                managedByTenantApprovers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .maximumActivationDuration(maximumActivationDuration?.applyValue({ args0 -> args0 }))
            .multiFactorAuthProvider(
                multiFactorAuthProvider.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [JustInTimeAccessPolicyArgs].
 */
@PulumiTagMarker
public class JustInTimeAccessPolicyArgsBuilder internal constructor() {
    private var managedByTenantApprovers: Output<List<EligibleApproverArgs>>? = null

    private var maximumActivationDuration: Output<String>? = null

    private var multiFactorAuthProvider: Output<Either<String, MultiFactorAuthProvider>>? = null

    /**
     * @param value The list of managedByTenant approvers for the eligible authorization.
     */
    @JvmName("nmjijlnphadlrdww")
    public suspend fun managedByTenantApprovers(`value`: Output<List<EligibleApproverArgs>>) {
        this.managedByTenantApprovers = value
    }

    @JvmName("wveqfqmesmjecghv")
    public suspend fun managedByTenantApprovers(vararg values: Output<EligibleApproverArgs>) {
        this.managedByTenantApprovers = Output.all(values.asList())
    }

    /**
     * @param values The list of managedByTenant approvers for the eligible authorization.
     */
    @JvmName("cxarnombnnbueumf")
    public suspend fun managedByTenantApprovers(values: List<Output<EligibleApproverArgs>>) {
        this.managedByTenantApprovers = Output.all(values)
    }

    /**
     * @param value The maximum access duration in ISO 8601 format for just-in-time access requests.
     */
    @JvmName("pfopqvlqpejwaino")
    public suspend fun maximumActivationDuration(`value`: Output<String>) {
        this.maximumActivationDuration = value
    }

    /**
     * @param value The multi-factor authorization provider to be used for just-in-time access requests.
     */
    @JvmName("yjrovooxxjeadamp")
    public suspend
    fun multiFactorAuthProvider(`value`: Output<Either<String, MultiFactorAuthProvider>>) {
        this.multiFactorAuthProvider = value
    }

    /**
     * @param value The list of managedByTenant approvers for the eligible authorization.
     */
    @JvmName("ctjmbvtsygfvrqpu")
    public suspend fun managedByTenantApprovers(`value`: List<EligibleApproverArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedByTenantApprovers = mapped
    }

    /**
     * @param argument The list of managedByTenant approvers for the eligible authorization.
     */
    @JvmName("lsyicibttuyellfn")
    public suspend
    fun managedByTenantApprovers(argument: List<suspend EligibleApproverArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EligibleApproverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedByTenantApprovers = mapped
    }

    /**
     * @param argument The list of managedByTenant approvers for the eligible authorization.
     */
    @JvmName("qngkxnwiohahcuah")
    public suspend fun managedByTenantApprovers(
        vararg
        argument: suspend EligibleApproverArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EligibleApproverArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.managedByTenantApprovers = mapped
    }

    /**
     * @param argument The list of managedByTenant approvers for the eligible authorization.
     */
    @JvmName("qkahqmdnhjjbdfng")
    public suspend
    fun managedByTenantApprovers(argument: suspend EligibleApproverArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EligibleApproverArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.managedByTenantApprovers = mapped
    }

    /**
     * @param values The list of managedByTenant approvers for the eligible authorization.
     */
    @JvmName("lyjigomxkbeogtig")
    public suspend fun managedByTenantApprovers(vararg values: EligibleApproverArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedByTenantApprovers = mapped
    }

    /**
     * @param value The maximum access duration in ISO 8601 format for just-in-time access requests.
     */
    @JvmName("hvsawgglsutxxoqr")
    public suspend fun maximumActivationDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumActivationDuration = mapped
    }

    /**
     * @param value The multi-factor authorization provider to be used for just-in-time access requests.
     */
    @JvmName("hblfhlrctfttifob")
    public suspend fun multiFactorAuthProvider(`value`: Either<String, MultiFactorAuthProvider>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiFactorAuthProvider = mapped
    }

    /**
     * @param value The multi-factor authorization provider to be used for just-in-time access requests.
     */
    @JvmName("xplrecxsssyffdwg")
    public fun multiFactorAuthProvider(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MultiFactorAuthProvider>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiFactorAuthProvider = mapped
    }

    /**
     * @param value The multi-factor authorization provider to be used for just-in-time access requests.
     */
    @JvmName("mnubdddokruxneid")
    public fun multiFactorAuthProvider(`value`: MultiFactorAuthProvider) {
        val toBeMapped = Either.ofRight<String, MultiFactorAuthProvider>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiFactorAuthProvider = mapped
    }

    internal fun build(): JustInTimeAccessPolicyArgs = JustInTimeAccessPolicyArgs(
        managedByTenantApprovers = managedByTenantApprovers,
        maximumActivationDuration = maximumActivationDuration,
        multiFactorAuthProvider = multiFactorAuthProvider ?: throw
            PulumiNullFieldException("multiFactorAuthProvider"),
    )
}
