@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Azure Active Directory principal identifier and Azure built-in role that describes the access the principal will receive on the delegated resource in the managed tenant.
 * @property delegatedRoleDefinitionIds The delegatedRoleDefinitionIds field is required when the roleDefinitionId refers to the User Access Administrator Role. It is the list of role definition ids which define all the permissions that the user in the authorization can assign to other principals.
 * @property principalId The identifier of the Azure Active Directory principal.
 * @property principalIdDisplayName The display name of the Azure Active Directory principal.
 * @property roleDefinitionId The identifier of the Azure built-in role that defines the permissions that the Azure Active Directory principal will have on the projected scope.
 */
public data class AuthorizationResponse(
    public val delegatedRoleDefinitionIds: List<String>? = null,
    public val principalId: String,
    public val principalIdDisplayName: String? = null,
    public val roleDefinitionId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managedservices.outputs.AuthorizationResponse):
            AuthorizationResponse = AuthorizationResponse(
            delegatedRoleDefinitionIds = javaType.delegatedRoleDefinitionIds().map({ args0 -> args0 }),
            principalId = javaType.principalId(),
            principalIdDisplayName = javaType.principalIdDisplayName().map({ args0 -> args0 }).orElse(null),
            roleDefinitionId = javaType.roleDefinitionId(),
        )
    }
}
