@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of a registration definition.
 * @property authorizations The collection of authorization objects describing the access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
 * @property description The description of the registration definition.
 * @property eligibleAuthorizations The collection of eligible authorization objects describing the just-in-time access Azure Active Directory principals in the managedBy tenant will receive on the delegated resource in the managed tenant.
 * @property managedByTenantId The identifier of the managedBy tenant.
 * @property managedByTenantName The name of the managedBy tenant.
 * @property manageeTenantId The identifier of the managed tenant.
 * @property manageeTenantName The name of the managed tenant.
 * @property provisioningState The current provisioning state of the registration definition.
 * @property registrationDefinitionName The name of the registration definition.
 */
public data class RegistrationDefinitionPropertiesResponse(
    public val authorizations: List<AuthorizationResponse>,
    public val description: String? = null,
    public val eligibleAuthorizations: List<EligibleAuthorizationResponse>? = null,
    public val managedByTenantId: String,
    public val managedByTenantName: String,
    public val manageeTenantId: String,
    public val manageeTenantName: String,
    public val provisioningState: String,
    public val registrationDefinitionName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managedservices.outputs.RegistrationDefinitionPropertiesResponse):
            RegistrationDefinitionPropertiesResponse = RegistrationDefinitionPropertiesResponse(
            authorizations = javaType.authorizations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managedservices.kotlin.outputs.AuthorizationResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            eligibleAuthorizations = javaType.eligibleAuthorizations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managedservices.kotlin.outputs.EligibleAuthorizationResponse.Companion.toKotlin(args0)
                })
            }),
            managedByTenantId = javaType.managedByTenantId(),
            managedByTenantName = javaType.managedByTenantName(),
            manageeTenantId = javaType.manageeTenantId(),
            manageeTenantName = javaType.manageeTenantName(),
            provisioningState = javaType.provisioningState(),
            registrationDefinitionName = javaType.registrationDefinitionName().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
