@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [HierarchySetting].
 */
@PulumiTagMarker
public class HierarchySettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HierarchySettingArgs = HierarchySettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HierarchySettingArgsBuilder.() -> Unit) {
        val builder = HierarchySettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): HierarchySetting {
        val builtJavaResource =
            com.pulumi.azurenative.management.HierarchySetting(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HierarchySetting(builtJavaResource)
    }
}

/**
 * Settings defined at the Management Group scope.
 * Azure REST API version: 2021-04-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2023-04-01.
 * ## Example Usage
 * ### GetGroupSettings
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hierarchySetting = new AzureNative.Management.HierarchySetting("hierarchySetting", new()
 *     {
 *         DefaultManagementGroup = "/providers/Microsoft.Management/managementGroups/DefaultGroup",
 *         GroupId = "root",
 *         RequireAuthorizationForGroupCreation = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/management/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := management.NewHierarchySetting(ctx, "hierarchySetting", &management.HierarchySettingArgs{
 * 			DefaultManagementGroup:               pulumi.String("/providers/Microsoft.Management/managementGroups/DefaultGroup"),
 * 			GroupId:                              pulumi.String("root"),
 * 			RequireAuthorizationForGroupCreation: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.management.HierarchySetting;
 * import com.pulumi.azurenative.management.HierarchySettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hierarchySetting = new HierarchySetting("hierarchySetting", HierarchySettingArgs.builder()
 *             .defaultManagementGroup("/providers/Microsoft.Management/managementGroups/DefaultGroup")
 *             .groupId("root")
 *             .requireAuthorizationForGroupCreation(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:management:HierarchySetting root /providers/Microsoft.Management/managementGroups/{groupId}/settings/default
 * ```
 */
public class HierarchySetting internal constructor(
    override val javaResource: com.pulumi.azurenative.management.HierarchySetting,
) : KotlinCustomResource(javaResource, HierarchySettingMapper) {
    /**
     * Settings that sets the default Management Group under which new subscriptions get added in this tenant. For example, /providers/Microsoft.Management/managementGroups/defaultGroup
     */
    public val defaultManagementGroup: Output<String>?
        get() = javaResource.defaultManagementGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the object. In this case, default.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Indicates whether RBAC access is required upon group creation under the root Management Group. If set to true, user will require Microsoft.Management/managementGroups/write action on the root Management Group scope in order to create new Groups directly under the root. This will prevent new users from creating new Management Groups, unless they are given access.
     */
    public val requireAuthorizationForGroupCreation: Output<Boolean>?
        get() = javaResource.requireAuthorizationForGroupCreation().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The AAD Tenant ID associated with the hierarchy settings. For example, 00000000-0000-0000-0000-000000000000
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource.  For example, Microsoft.Management/managementGroups/settings.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object HierarchySettingMapper : ResourceMapper<HierarchySetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.management.HierarchySetting::class == javaResource::class

    override fun map(javaResource: Resource): HierarchySetting = HierarchySetting(
        javaResource as
            com.pulumi.azurenative.management.HierarchySetting,
    )
}

/**
 * @see [HierarchySetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HierarchySetting].
 */
public suspend fun hierarchySetting(
    name: String,
    block: suspend HierarchySettingResourceBuilder.() -> Unit,
): HierarchySetting {
    val builder = HierarchySettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HierarchySetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hierarchySetting(name: String): HierarchySetting {
    val builder = HierarchySettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
