@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin

import com.pulumi.azurenative.management.kotlin.outputs.ManagementGroupChildInfoResponse
import com.pulumi.azurenative.management.kotlin.outputs.ManagementGroupDetailsResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.management.kotlin.outputs.ManagementGroupChildInfoResponse.Companion.toKotlin as managementGroupChildInfoResponseToKotlin
import com.pulumi.azurenative.management.kotlin.outputs.ManagementGroupDetailsResponse.Companion.toKotlin as managementGroupDetailsResponseToKotlin

/**
 * Builder for [ManagementGroup].
 */
@PulumiTagMarker
public class ManagementGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagementGroupArgs = ManagementGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagementGroupArgsBuilder.() -> Unit) {
        val builder = ManagementGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagementGroup {
        val builtJavaResource =
            com.pulumi.azurenative.management.ManagementGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagementGroup(builtJavaResource)
    }
}

/**
 * The management group details.
 * Azure REST API version: 2021-04-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2017-11-01-preview, 2020-02-01, 2023-04-01.
 * ## Example Usage
 * ### PutManagementGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementGroup = new AzureNative.Management.ManagementGroup("managementGroup", new()
 *     {
 *         Details = new AzureNative.Management.Inputs.CreateManagementGroupDetailsArgs
 *         {
 *             Parent = new AzureNative.Management.Inputs.CreateParentGroupInfoArgs
 *             {
 *                 Id = "/providers/Microsoft.Management/managementGroups/RootGroup",
 *             },
 *         },
 *         DisplayName = "ChildGroup",
 *         GroupId = "ChildGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/management/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := management.NewManagementGroup(ctx, "managementGroup", &management.ManagementGroupArgs{
 * 			Details: management.ManagementGroupDetailsResponse{
 * 				Parent: &management.CreateParentGroupInfoArgs{
 * 					Id: pulumi.String("/providers/Microsoft.Management/managementGroups/RootGroup"),
 * 				},
 * 			},
 * 			DisplayName: pulumi.String("ChildGroup"),
 * 			GroupId:     pulumi.String("ChildGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.management.ManagementGroup;
 * import com.pulumi.azurenative.management.ManagementGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementGroup = new ManagementGroup("managementGroup", ManagementGroupArgs.builder()
 *             .details(Map.of("parent", Map.of("id", "/providers/Microsoft.Management/managementGroups/RootGroup")))
 *             .displayName("ChildGroup")
 *             .groupId("ChildGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:management:ManagementGroup ChildGroup /providers/Microsoft.Management/managementGroups/{groupId}
 * ```
 */
public class ManagementGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.management.ManagementGroup,
) : KotlinCustomResource(javaResource, ManagementGroupMapper) {
    /**
     * The list of children.
     */
    public val children: Output<List<ManagementGroupChildInfoResponse>>?
        get() = javaResource.children().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> managementGroupChildInfoResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The details of a management group.
     */
    public val details: Output<ManagementGroupDetailsResponse>?
        get() = javaResource.details().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managementGroupDetailsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The friendly name of the management group.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the management group. For example, 00000000-0000-0000-0000-000000000000
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The AAD Tenant ID associated with the management group. For example, 00000000-0000-0000-0000-000000000000
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource.  For example, Microsoft.Management/managementGroups
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagementGroupMapper : ResourceMapper<ManagementGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.management.ManagementGroup::class == javaResource::class

    override fun map(javaResource: Resource): ManagementGroup = ManagementGroup(
        javaResource as
            com.pulumi.azurenative.management.ManagementGroup,
    )
}

/**
 * @see [ManagementGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagementGroup].
 */
public suspend fun managementGroup(
    name: String,
    block: suspend ManagementGroupResourceBuilder.() -> Unit,
): ManagementGroup {
    val builder = ManagementGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagementGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managementGroup(name: String): ManagementGroup {
    val builder = ManagementGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
