@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin.inputs

import com.pulumi.azurenative.management.inputs.CreateManagementGroupDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The details of a management group used during creation.
 * @property parent (Optional) The ID of the parent management group used during creation.
 */
public data class CreateManagementGroupDetailsArgs(
    public val parent: Output<CreateParentGroupInfoArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.management.inputs.CreateManagementGroupDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.management.inputs.CreateManagementGroupDetailsArgs =
        com.pulumi.azurenative.management.inputs.CreateManagementGroupDetailsArgs.builder()
            .parent(parent?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CreateManagementGroupDetailsArgs].
 */
@PulumiTagMarker
public class CreateManagementGroupDetailsArgsBuilder internal constructor() {
    private var parent: Output<CreateParentGroupInfoArgs>? = null

    /**
     * @param value (Optional) The ID of the parent management group used during creation.
     */
    @JvmName("luyuksfbesxqjwha")
    public suspend fun parent(`value`: Output<CreateParentGroupInfoArgs>) {
        this.parent = value
    }

    /**
     * @param value (Optional) The ID of the parent management group used during creation.
     */
    @JvmName("hdqvyajobjqpuewk")
    public suspend fun parent(`value`: CreateParentGroupInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parent = mapped
    }

    /**
     * @param argument (Optional) The ID of the parent management group used during creation.
     */
    @JvmName("sqmrpquuemjdavip")
    public suspend fun parent(argument: suspend CreateParentGroupInfoArgsBuilder.() -> Unit) {
        val toBeMapped = CreateParentGroupInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parent = mapped
    }

    internal fun build(): CreateManagementGroupDetailsArgs = CreateManagementGroupDetailsArgs(
        parent = parent,
    )
}
