@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The entity.
 * @property displayName The friendly name of the management group.
 * @property id The fully qualified ID for the entity.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
 * @property inheritedPermissions The users specific permissions to this item.
 * @property name The name of the entity. For example, 00000000-0000-0000-0000-000000000000
 * @property numberOfChildGroups Number of children is the number of Groups that are exactly one level underneath the current Group.
 * @property numberOfChildren Number of children is the number of Groups and Subscriptions that are exactly one level underneath the current Group.
 * @property numberOfDescendants
 * @property parent (Optional) The ID of the parent management group.
 * @property parentDisplayNameChain The parent display name chain from the root group to the immediate parent
 * @property parentNameChain The parent name chain from the root group to the immediate parent
 * @property permissions The users specific permissions to this item.
 * @property tenantId The AAD Tenant ID associated with the entity. For example, 00000000-0000-0000-0000-000000000000
 * @property type The type of the resource. For example, Microsoft.Management/managementGroups
 */
public data class EntityInfoResponse(
    public val displayName: String? = null,
    public val id: String,
    public val inheritedPermissions: String? = null,
    public val name: String,
    public val numberOfChildGroups: Int? = null,
    public val numberOfChildren: Int? = null,
    public val numberOfDescendants: Int? = null,
    public val parent: EntityParentGroupInfoResponse? = null,
    public val parentDisplayNameChain: List<String>? = null,
    public val parentNameChain: List<String>? = null,
    public val permissions: String? = null,
    public val tenantId: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.management.outputs.EntityInfoResponse):
            EntityInfoResponse = EntityInfoResponse(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            inheritedPermissions = javaType.inheritedPermissions().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            numberOfChildGroups = javaType.numberOfChildGroups().map({ args0 -> args0 }).orElse(null),
            numberOfChildren = javaType.numberOfChildren().map({ args0 -> args0 }).orElse(null),
            numberOfDescendants = javaType.numberOfDescendants().map({ args0 -> args0 }).orElse(null),
            parent = javaType.parent().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.management.kotlin.outputs.EntityParentGroupInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            parentDisplayNameChain = javaType.parentDisplayNameChain().map({ args0 -> args0 }),
            parentNameChain = javaType.parentNameChain().map({ args0 -> args0 }),
            permissions = javaType.permissions().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
