@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The management group details.
 * @property children The list of children.
 * @property details The details of a management group.
 * @property displayName The friendly name of the management group.
 * @property id The fully qualified ID for the management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
 * @property name The name of the management group. For example, 00000000-0000-0000-0000-000000000000
 * @property tenantId The AAD Tenant ID associated with the management group. For example, 00000000-0000-0000-0000-000000000000
 * @property type The type of the resource.  For example, Microsoft.Management/managementGroups
 */
public data class GetManagementGroupResult(
    public val children: List<ManagementGroupChildInfoResponse>? = null,
    public val details: ManagementGroupDetailsResponse? = null,
    public val displayName: String? = null,
    public val id: String,
    public val name: String,
    public val tenantId: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.management.outputs.GetManagementGroupResult):
            GetManagementGroupResult = GetManagementGroupResult(
            children = javaType.children().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.management.kotlin.outputs.ManagementGroupChildInfoResponse.Companion.toKotlin(args0)
                })
            }),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.management.kotlin.outputs.ManagementGroupDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
