@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.management.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * (Optional) The ID of the parent management group.
 * @property displayName The friendly name of the parent management group.
 * @property id The fully qualified ID for the parent management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
 * @property name The name of the parent management group
 */
public data class ParentGroupInfoResponse(
    public val displayName: String? = null,
    public val id: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.management.outputs.ParentGroupInfoResponse):
            ParentGroupInfoResponse = ParentGroupInfoResponse(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
