@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin.inputs

import com.pulumi.azurenative.maps.inputs.GetCreatorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the Maps Account.
 * @property creatorName The name of the Maps Creator instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCreatorPlainArgs(
    public val accountName: String,
    public val creatorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.maps.inputs.GetCreatorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.maps.inputs.GetCreatorPlainArgs =
        com.pulumi.azurenative.maps.inputs.GetCreatorPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .creatorName(creatorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCreatorPlainArgs].
 */
@PulumiTagMarker
public class GetCreatorPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var creatorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Maps Account.
     */
    @JvmName("wxmnaixbwixfespp")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the Maps Creator instance.
     */
    @JvmName("laabqjsifeqtsvqt")
    public suspend fun creatorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.creatorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nmqgyxwwsntxljjn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCreatorPlainArgs = GetCreatorPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        creatorName = creatorName ?: throw PulumiNullFieldException("creatorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
