@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin.inputs

import com.pulumi.azurenative.maps.inputs.MapsAccountPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Additional Map account properties
 * @property disableLocalAuth Allows toggle functionality on Azure Policy to disable Azure Maps local authentication support. This will disable Shared Keys authentication from any usage.
 */
public data class MapsAccountPropertiesArgs(
    public val disableLocalAuth: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.maps.inputs.MapsAccountPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.maps.inputs.MapsAccountPropertiesArgs =
        com.pulumi.azurenative.maps.inputs.MapsAccountPropertiesArgs.builder()
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MapsAccountPropertiesArgs].
 */
@PulumiTagMarker
public class MapsAccountPropertiesArgsBuilder internal constructor() {
    private var disableLocalAuth: Output<Boolean>? = null

    /**
     * @param value Allows toggle functionality on Azure Policy to disable Azure Maps local authentication support. This will disable Shared Keys authentication from any usage.
     */
    @JvmName("dwypcrskwkyaqtbm")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value Allows toggle functionality on Azure Policy to disable Azure Maps local authentication support. This will disable Shared Keys authentication from any usage.
     */
    @JvmName("lybalhthrllobanw")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    internal fun build(): MapsAccountPropertiesArgs = MapsAccountPropertiesArgs(
        disableLocalAuth = disableLocalAuth,
    )
}
