@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maps.kotlin.inputs

import com.pulumi.azurenative.maps.inputs.SkuArgs.builder
import com.pulumi.azurenative.maps.kotlin.enums.Name
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The SKU of the Maps Account.
 * @property name The name of the SKU, in standard format (such as S0).
 */
public data class SkuArgs(
    public val name: Output<Either<String, Name>>,
) : ConvertibleToJava<com.pulumi.azurenative.maps.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.maps.inputs.SkuArgs =
        com.pulumi.azurenative.maps.inputs.SkuArgs.builder()
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, Name>>? = null

    /**
     * @param value The name of the SKU, in standard format (such as S0).
     */
    @JvmName("abqkaxovlklextha")
    public suspend fun name(`value`: Output<Either<String, Name>>) {
        this.name = value
    }

    /**
     * @param value The name of the SKU, in standard format (such as S0).
     */
    @JvmName("aplgpdlexajteoyp")
    public suspend fun name(`value`: Either<String, Name>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU, in standard format (such as S0).
     */
    @JvmName("jkhiwiinavbtgmbb")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Name>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU, in standard format (such as S0).
     */
    @JvmName("vfqxkiemrfcvyhik")
    public fun name(`value`: Name) {
        val toBeMapped = Either.ofRight<String, Name>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
