@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin

import com.pulumi.azurenative.marketplace.PrivateStoreCollectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Collection data structure.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2021-12-01.
 * ## Example Usage
 * ### CreatePrivateStoreCollection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateStoreCollection = new AzureNative.Marketplace.PrivateStoreCollection("privateStoreCollection", new()
 *     {
 *         AllSubscriptions = false,
 *         Claim = "",
 *         CollectionId = "d0f5aa2c-ecc3-4d87-906a-f8c486dcc4f1",
 *         CollectionName = "Test Collection",
 *         PrivateStoreId = "a0e28e55-90c4-41d8-8e34-bb7ef7775406",
 *         SubscriptionsList = new[]
 *         {
 *             "b340914e-353d-453a-85fb-8f9b65b51f91",
 *             "f2baa04d-5bfc-461b-b6d8-61b403c9ec48",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/marketplace/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := marketplace.NewPrivateStoreCollection(ctx, "privateStoreCollection", &marketplace.PrivateStoreCollectionArgs{
 * 			AllSubscriptions: pulumi.Bool(false),
 * 			Claim:            pulumi.String(""),
 * 			CollectionId:     pulumi.String("d0f5aa2c-ecc3-4d87-906a-f8c486dcc4f1"),
 * 			CollectionName:   pulumi.String("Test Collection"),
 * 			PrivateStoreId:   pulumi.String("a0e28e55-90c4-41d8-8e34-bb7ef7775406"),
 * 			SubscriptionsList: pulumi.StringArray{
 * 				pulumi.String("b340914e-353d-453a-85fb-8f9b65b51f91"),
 * 				pulumi.String("f2baa04d-5bfc-461b-b6d8-61b403c9ec48"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.marketplace.PrivateStoreCollection;
 * import com.pulumi.azurenative.marketplace.PrivateStoreCollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateStoreCollection = new PrivateStoreCollection("privateStoreCollection", PrivateStoreCollectionArgs.builder()
 *             .allSubscriptions(false)
 *             .claim("")
 *             .collectionId("d0f5aa2c-ecc3-4d87-906a-f8c486dcc4f1")
 *             .collectionName("Test Collection")
 *             .privateStoreId("a0e28e55-90c4-41d8-8e34-bb7ef7775406")
 *             .subscriptionsList(
 *                 "b340914e-353d-453a-85fb-8f9b65b51f91",
 *                 "f2baa04d-5bfc-461b-b6d8-61b403c9ec48")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:marketplace:PrivateStoreCollection d0f5aa2c-ecc3-4d87-906a-f8c486dcc4f1 /providers/Microsoft.Marketplace/privateStores/{privateStoreId}/collections/{collectionId}
 * ```
 * @property allSubscriptions Indicating whether all subscriptions are selected (=true) or not (=false).
 * @property claim Gets or sets the association with Commercial's Billing Account.
 * @property collectionId The collection ID
 * @property collectionName Gets or sets collection name.
 * @property enabled Indicating whether the collection is enabled or disabled.
 * @property privateStoreId The store ID - must use the tenant ID
 * @property subscriptionsList Gets or sets subscription ids list. Empty list indicates all subscriptions are selected, null indicates no update is done, explicit list indicates the explicit selected subscriptions. On insert, null is considered as bad request
 */
public data class PrivateStoreCollectionArgs(
    public val allSubscriptions: Output<Boolean>? = null,
    public val claim: Output<String>? = null,
    public val collectionId: Output<String>? = null,
    public val collectionName: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val privateStoreId: Output<String>? = null,
    public val subscriptionsList: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.marketplace.PrivateStoreCollectionArgs> {
    override fun toJava(): com.pulumi.azurenative.marketplace.PrivateStoreCollectionArgs =
        com.pulumi.azurenative.marketplace.PrivateStoreCollectionArgs.builder()
            .allSubscriptions(allSubscriptions?.applyValue({ args0 -> args0 }))
            .claim(claim?.applyValue({ args0 -> args0 }))
            .collectionId(collectionId?.applyValue({ args0 -> args0 }))
            .collectionName(collectionName?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .privateStoreId(privateStoreId?.applyValue({ args0 -> args0 }))
            .subscriptionsList(subscriptionsList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PrivateStoreCollectionArgs].
 */
@PulumiTagMarker
public class PrivateStoreCollectionArgsBuilder internal constructor() {
    private var allSubscriptions: Output<Boolean>? = null

    private var claim: Output<String>? = null

    private var collectionId: Output<String>? = null

    private var collectionName: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var privateStoreId: Output<String>? = null

    private var subscriptionsList: Output<List<String>>? = null

    /**
     * @param value Indicating whether all subscriptions are selected (=true) or not (=false).
     */
    @JvmName("paylefrjfupsioyc")
    public suspend fun allSubscriptions(`value`: Output<Boolean>) {
        this.allSubscriptions = value
    }

    /**
     * @param value Gets or sets the association with Commercial's Billing Account.
     */
    @JvmName("enghjateknhtvjqi")
    public suspend fun claim(`value`: Output<String>) {
        this.claim = value
    }

    /**
     * @param value The collection ID
     */
    @JvmName("yvgttsucfehfdalw")
    public suspend fun collectionId(`value`: Output<String>) {
        this.collectionId = value
    }

    /**
     * @param value Gets or sets collection name.
     */
    @JvmName("pwfaprbhswrwcvax")
    public suspend fun collectionName(`value`: Output<String>) {
        this.collectionName = value
    }

    /**
     * @param value Indicating whether the collection is enabled or disabled.
     */
    @JvmName("evvmqakoadqjnuqk")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The store ID - must use the tenant ID
     */
    @JvmName("fmdsfwsejbqfusum")
    public suspend fun privateStoreId(`value`: Output<String>) {
        this.privateStoreId = value
    }

    /**
     * @param value Gets or sets subscription ids list. Empty list indicates all subscriptions are selected, null indicates no update is done, explicit list indicates the explicit selected subscriptions. On insert, null is considered as bad request
     */
    @JvmName("crwucipwtdftrkee")
    public suspend fun subscriptionsList(`value`: Output<List<String>>) {
        this.subscriptionsList = value
    }

    @JvmName("eqevdidmdrkkfleb")
    public suspend fun subscriptionsList(vararg values: Output<String>) {
        this.subscriptionsList = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets subscription ids list. Empty list indicates all subscriptions are selected, null indicates no update is done, explicit list indicates the explicit selected subscriptions. On insert, null is considered as bad request
     */
    @JvmName("rqgpgoemhsofmoib")
    public suspend fun subscriptionsList(values: List<Output<String>>) {
        this.subscriptionsList = Output.all(values)
    }

    /**
     * @param value Indicating whether all subscriptions are selected (=true) or not (=false).
     */
    @JvmName("wpunsjpsswcrsrkf")
    public suspend fun allSubscriptions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allSubscriptions = mapped
    }

    /**
     * @param value Gets or sets the association with Commercial's Billing Account.
     */
    @JvmName("ejkdgkxvldopbeoj")
    public suspend fun claim(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.claim = mapped
    }

    /**
     * @param value The collection ID
     */
    @JvmName("ufcdlynerkqovjwi")
    public suspend fun collectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectionId = mapped
    }

    /**
     * @param value Gets or sets collection name.
     */
    @JvmName("suipwhobgfhamgyq")
    public suspend fun collectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collectionName = mapped
    }

    /**
     * @param value Indicating whether the collection is enabled or disabled.
     */
    @JvmName("ayspveiotlaitmgx")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The store ID - must use the tenant ID
     */
    @JvmName("aevpfnlbustwwsyf")
    public suspend fun privateStoreId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateStoreId = mapped
    }

    /**
     * @param value Gets or sets subscription ids list. Empty list indicates all subscriptions are selected, null indicates no update is done, explicit list indicates the explicit selected subscriptions. On insert, null is considered as bad request
     */
    @JvmName("jksnwntohbgqbhvi")
    public suspend fun subscriptionsList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionsList = mapped
    }

    /**
     * @param values Gets or sets subscription ids list. Empty list indicates all subscriptions are selected, null indicates no update is done, explicit list indicates the explicit selected subscriptions. On insert, null is considered as bad request
     */
    @JvmName("ewbvmhrsdexfjpdm")
    public suspend fun subscriptionsList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptionsList = mapped
    }

    internal fun build(): PrivateStoreCollectionArgs = PrivateStoreCollectionArgs(
        allSubscriptions = allSubscriptions,
        claim = claim,
        collectionId = collectionId,
        collectionName = collectionName,
        enabled = enabled,
        privateStoreId = privateStoreId,
        subscriptionsList = subscriptionsList,
    )
}
