@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin.inputs

import com.pulumi.azurenative.marketplace.inputs.GetPrivateStoreCollectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property collectionId The collection ID
 * @property privateStoreId The store ID - must use the tenant ID
 */
public data class GetPrivateStoreCollectionPlainArgs(
    public val collectionId: String,
    public val privateStoreId: String,
) : ConvertibleToJava<com.pulumi.azurenative.marketplace.inputs.GetPrivateStoreCollectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.marketplace.inputs.GetPrivateStoreCollectionPlainArgs =
        com.pulumi.azurenative.marketplace.inputs.GetPrivateStoreCollectionPlainArgs.builder()
            .collectionId(collectionId.let({ args0 -> args0 }))
            .privateStoreId(privateStoreId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateStoreCollectionPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateStoreCollectionPlainArgsBuilder internal constructor() {
    private var collectionId: String? = null

    private var privateStoreId: String? = null

    /**
     * @param value The collection ID
     */
    @JvmName("berewwbcjkpxdqdh")
    public suspend fun collectionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.collectionId = mapped
    }

    /**
     * @param value The store ID - must use the tenant ID
     */
    @JvmName("tqpswxexvhdultkv")
    public suspend fun privateStoreId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateStoreId = mapped
    }

    internal fun build(): GetPrivateStoreCollectionPlainArgs = GetPrivateStoreCollectionPlainArgs(
        collectionId = collectionId ?: throw PulumiNullFieldException("collectionId"),
        privateStoreId = privateStoreId ?: throw PulumiNullFieldException("privateStoreId"),
    )
}
