@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin.inputs

import com.pulumi.azurenative.marketplace.inputs.ListPrivateStoreStopSellOffersPlansNotificationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property privateStoreId The store ID - must use the tenant ID
 * @property subscriptions
 */
public data class ListPrivateStoreStopSellOffersPlansNotificationsPlainArgs(
    public val privateStoreId: String,
    public val subscriptions: List<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.marketplace.inputs.ListPrivateStoreStopSellOffersPlansNotificationsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.marketplace.inputs.ListPrivateStoreStopSellOffersPlansNotificationsPlainArgs =
        com.pulumi.azurenative.marketplace.inputs.ListPrivateStoreStopSellOffersPlansNotificationsPlainArgs.builder()
            .privateStoreId(privateStoreId.let({ args0 -> args0 }))
            .subscriptions(subscriptions?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ListPrivateStoreStopSellOffersPlansNotificationsPlainArgs].
 */
@PulumiTagMarker
public class ListPrivateStoreStopSellOffersPlansNotificationsPlainArgsBuilder internal constructor() {
    private var privateStoreId: String? = null

    private var subscriptions: List<String>? = null

    /**
     * @param value The store ID - must use the tenant ID
     */
    @JvmName("niyovylmcwysuyhj")
    public suspend fun privateStoreId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateStoreId = mapped
    }

    /**
     * @param value
     */
    @JvmName("duwwcvltlhkgbqnx")
    public suspend fun subscriptions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subscriptions = mapped
    }

    /**
     * @param values
     */
    @JvmName("tadwuoxtgbchuxvx")
    public suspend fun subscriptions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.subscriptions = mapped
    }

    internal fun build(): ListPrivateStoreStopSellOffersPlansNotificationsPlainArgs =
        ListPrivateStoreStopSellOffersPlansNotificationsPlainArgs(
            privateStoreId = privateStoreId ?: throw PulumiNullFieldException("privateStoreId"),
            subscriptions = subscriptions,
        )
}
