@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The privateStore offer data structure.
 * @property createdAt Private store offer creation date
 * @property eTag Identifier for purposes of race condition
 * @property iconFileUris Icon File Uris
 * @property id The resource ID.
 * @property modifiedAt Private store offer modification date
 * @property name The name of the resource.
 * @property offerDisplayName It will be displayed prominently in the marketplace
 * @property plans Offer plans
 * @property privateStoreId Private store unique id
 * @property publisherDisplayName Publisher name that will be displayed prominently in the marketplace
 * @property specificPlanIdsLimitation Plan ids limitation for this offer
 * @property systemData Metadata pertaining to creation and last modification of the resource
 * @property type The type of the resource.
 * @property uniqueOfferId Offers unique id
 * @property updateSuppressedDueIdempotence Indicating whether the offer was not updated to db (true = not updated). If the allow list is identical to the existed one in db, the offer would not be updated.
 */
public data class GetPrivateStoreCollectionOfferResult(
    public val createdAt: String,
    public val eTag: String? = null,
    public val iconFileUris: Map<String, String>? = null,
    public val id: String,
    public val modifiedAt: String,
    public val name: String,
    public val offerDisplayName: String,
    public val plans: List<PlanResponse>? = null,
    public val privateStoreId: String,
    public val publisherDisplayName: String,
    public val specificPlanIdsLimitation: List<String>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val uniqueOfferId: String,
    public val updateSuppressedDueIdempotence: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.marketplace.outputs.GetPrivateStoreCollectionOfferResult):
            GetPrivateStoreCollectionOfferResult = GetPrivateStoreCollectionOfferResult(
            createdAt = javaType.createdAt(),
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            iconFileUris = javaType.iconFileUris().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            id = javaType.id(),
            modifiedAt = javaType.modifiedAt(),
            name = javaType.name(),
            offerDisplayName = javaType.offerDisplayName(),
            plans = javaType.plans().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.marketplace.kotlin.outputs.PlanResponse.Companion.toKotlin(args0)
                })
            }),
            privateStoreId = javaType.privateStoreId(),
            publisherDisplayName = javaType.publisherDisplayName(),
            specificPlanIdsLimitation = javaType.specificPlanIdsLimitation().map({ args0 -> args0 }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.marketplace.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            uniqueOfferId = javaType.uniqueOfferId(),
            updateSuppressedDueIdempotence = javaType.updateSuppressedDueIdempotence().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
