@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * List of stop sell offers and plans notifications.
 * @property displayName The offer display name
 * @property icon The icon url
 * @property isEntire A value indicating whether entire offer is in stop sell or only few of its plans
 * @property messageCode The notification message code
 * @property offerId The offer id
 * @property plans The list of removed plans notifications
 * @property publicContext True if the offer has public plans
 * @property subscriptionsIds The subscriptions related to private plans
 */
public data class StopSellOffersPlansNotificationsListPropertiesResponse(
    public val displayName: String,
    public val icon: String,
    public val isEntire: Boolean,
    public val messageCode: Double,
    public val offerId: String,
    public val plans: List<PlanNotificationDetailsResponse>,
    public val publicContext: Boolean,
    public val subscriptionsIds: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.marketplace.outputs.StopSellOffersPlansNotificationsListPropertiesResponse):
            StopSellOffersPlansNotificationsListPropertiesResponse =
            StopSellOffersPlansNotificationsListPropertiesResponse(
                displayName = javaType.displayName(),
                icon = javaType.icon(),
                isEntire = javaType.isEntire(),
                messageCode = javaType.messageCode(),
                offerId = javaType.offerId(),
                plans = javaType.plans().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.marketplace.kotlin.outputs.PlanNotificationDetailsResponse.Companion.toKotlin(args0)
                    })
                }),
                publicContext = javaType.publicContext(),
                subscriptionsIds = javaType.subscriptionsIds().map({ args0 -> args0 }),
            )
    }
}
