@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.AssetFilterArgs.builder
import com.pulumi.azurenative.media.kotlin.inputs.FilterTrackSelectionArgs
import com.pulumi.azurenative.media.kotlin.inputs.FilterTrackSelectionArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.FirstQualityArgs
import com.pulumi.azurenative.media.kotlin.inputs.FirstQualityArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.PresentationTimeRangeArgs
import com.pulumi.azurenative.media.kotlin.inputs.PresentationTimeRangeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An Asset Filter.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create an Asset Filter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assetFilter = new AzureNative.Media.AssetFilter("assetFilter", new()
 *     {
 *         AccountName = "contosomedia",
 *         AssetName = "ClimbingMountRainer",
 *         FilterName = "newAssetFilter",
 *         FirstQuality = new AzureNative.Media.Inputs.FirstQualityArgs
 *         {
 *             Bitrate = 128000,
 *         },
 *         PresentationTimeRange = new AzureNative.Media.Inputs.PresentationTimeRangeArgs
 *         {
 *             EndTimestamp = 170000000,
 *             ForceEndTimestamp = false,
 *             LiveBackoffDuration = 0,
 *             PresentationWindowDuration = 9223372036854774784,
 *             StartTimestamp = 0,
 *             Timescale = 10000000,
 *         },
 *         ResourceGroupName = "contosorg",
 *         Tracks = new[]
 *         {
 *             new AzureNative.Media.Inputs.FilterTrackSelectionArgs
 *             {
 *                 TrackSelections = new[]
 *                 {
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = "Equal",
 *                         Property = "Type",
 *                         Value = "Audio",
 *                     },
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = "NotEqual",
 *                         Property = "Language",
 *                         Value = "en",
 *                     },
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = "NotEqual",
 *                         Property = "FourCC",
 *                         Value = "EC-3",
 *                     },
 *                 },
 *             },
 *             new AzureNative.Media.Inputs.FilterTrackSelectionArgs
 *             {
 *                 TrackSelections = new[]
 *                 {
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = "Equal",
 *                         Property = "Type",
 *                         Value = "Video",
 *                     },
 *                     new AzureNative.Media.Inputs.FilterTrackPropertyConditionArgs
 *                     {
 *                         Operation = "Equal",
 *                         Property = "Bitrate",
 *                         Value = "3000000-5000000",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewAssetFilter(ctx, "assetFilter", &media.AssetFilterArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			AssetName:   pulumi.String("ClimbingMountRainer"),
 * 			FilterName:  pulumi.String("newAssetFilter"),
 * 			FirstQuality: &media.FirstQualityArgs{
 * 				Bitrate: pulumi.Int(128000),
 * 			},
 * 			PresentationTimeRange: &media.PresentationTimeRangeArgs{
 * 				EndTimestamp:               pulumi.Float64(170000000),
 * 				ForceEndTimestamp:          pulumi.Bool(false),
 * 				LiveBackoffDuration:        pulumi.Float64(0),
 * 				PresentationWindowDuration: pulumi.Float64(9223372036854774784),
 * 				StartTimestamp:             pulumi.Float64(0),
 * 				Timescale:                  pulumi.Float64(10000000),
 * 			},
 * 			ResourceGroupName: pulumi.String("contosorg"),
 * 			Tracks: []media.FilterTrackSelectionArgs{
 * 				{
 * 					TrackSelections: media.FilterTrackPropertyConditionArray{
 * 						{
 * 							Operation: pulumi.String("Equal"),
 * 							Property:  pulumi.String("Type"),
 * 							Value:     pulumi.String("Audio"),
 * 						},
 * 						{
 * 							Operation: pulumi.String("NotEqual"),
 * 							Property:  pulumi.String("Language"),
 * 							Value:     pulumi.String("en"),
 * 						},
 * 						{
 * 							Operation: pulumi.String("NotEqual"),
 * 							Property:  pulumi.String("FourCC"),
 * 							Value:     pulumi.String("EC-3"),
 * 						},
 * 					},
 * 				},
 * 				{
 * 					TrackSelections: media.FilterTrackPropertyConditionArray{
 * 						{
 * 							Operation: pulumi.String("Equal"),
 * 							Property:  pulumi.String("Type"),
 * 							Value:     pulumi.String("Video"),
 * 						},
 * 						{
 * 							Operation: pulumi.String("Equal"),
 * 							Property:  pulumi.String("Bitrate"),
 * 							Value:     pulumi.String("3000000-5000000"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.AssetFilter;
 * import com.pulumi.azurenative.media.AssetFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assetFilter = new AssetFilter("assetFilter", AssetFilterArgs.builder()
 *             .accountName("contosomedia")
 *             .assetName("ClimbingMountRainer")
 *             .filterName("newAssetFilter")
 *             .firstQuality(Map.of("bitrate", 128000))
 *             .presentationTimeRange(Map.ofEntries(
 *                 Map.entry("endTimestamp", 170000000),
 *                 Map.entry("forceEndTimestamp", false),
 *                 Map.entry("liveBackoffDuration", 0),
 *                 Map.entry("presentationWindowDuration", 9223372036854774784),
 *                 Map.entry("startTimestamp", 0),
 *                 Map.entry("timescale", 10000000)
 *             ))
 *             .resourceGroupName("contosorg")
 *             .tracks(
 *                 Map.of("trackSelections",
 *                     Map.ofEntries(
 *                         Map.entry("operation", "Equal"),
 *                         Map.entry("property", "Type"),
 *                         Map.entry("value", "Audio")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("operation", "NotEqual"),
 *                         Map.entry("property", "Language"),
 *                         Map.entry("value", "en")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("operation", "NotEqual"),
 *                         Map.entry("property", "FourCC"),
 *                         Map.entry("value", "EC-3")
 *                     )),
 *                 Map.of("trackSelections",
 *                     Map.ofEntries(
 *                         Map.entry("operation", "Equal"),
 *                         Map.entry("property", "Type"),
 *                         Map.entry("value", "Video")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("operation", "Equal"),
 *                         Map.entry("property", "Bitrate"),
 *                         Map.entry("value", "3000000-5000000")
 *                     )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:AssetFilter newAssetFilter /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/assets/{assetName}/assetFilters/{filterName}
 * ```
 * @property accountName The Media Services account name.
 * @property assetName The Asset name.
 * @property filterName The Asset Filter name
 * @property firstQuality The first quality.
 * @property presentationTimeRange The presentation time range.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property tracks The tracks selection conditions.
 */
public data class AssetFilterArgs(
    public val accountName: Output<String>? = null,
    public val assetName: Output<String>? = null,
    public val filterName: Output<String>? = null,
    public val firstQuality: Output<FirstQualityArgs>? = null,
    public val presentationTimeRange: Output<PresentationTimeRangeArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tracks: Output<List<FilterTrackSelectionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.AssetFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.media.AssetFilterArgs =
        com.pulumi.azurenative.media.AssetFilterArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .assetName(assetName?.applyValue({ args0 -> args0 }))
            .filterName(filterName?.applyValue({ args0 -> args0 }))
            .firstQuality(firstQuality?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .presentationTimeRange(
                presentationTimeRange?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tracks(
                tracks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AssetFilterArgs].
 */
@PulumiTagMarker
public class AssetFilterArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var assetName: Output<String>? = null

    private var filterName: Output<String>? = null

    private var firstQuality: Output<FirstQualityArgs>? = null

    private var presentationTimeRange: Output<PresentationTimeRangeArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tracks: Output<List<FilterTrackSelectionArgs>>? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("syqwoekwmgsuawxs")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The Asset name.
     */
    @JvmName("bcfpwrroclbgxmct")
    public suspend fun assetName(`value`: Output<String>) {
        this.assetName = value
    }

    /**
     * @param value The Asset Filter name
     */
    @JvmName("wrmyqxmxpveeqwsn")
    public suspend fun filterName(`value`: Output<String>) {
        this.filterName = value
    }

    /**
     * @param value The first quality.
     */
    @JvmName("chvkvsbsskescgsq")
    public suspend fun firstQuality(`value`: Output<FirstQualityArgs>) {
        this.firstQuality = value
    }

    /**
     * @param value The presentation time range.
     */
    @JvmName("onqplrpgxnxwytau")
    public suspend fun presentationTimeRange(`value`: Output<PresentationTimeRangeArgs>) {
        this.presentationTimeRange = value
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("vinqxcplaplltgtk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tracks selection conditions.
     */
    @JvmName("fcnwqnvhpjmktlxp")
    public suspend fun tracks(`value`: Output<List<FilterTrackSelectionArgs>>) {
        this.tracks = value
    }

    @JvmName("wmssmfprbpqabvib")
    public suspend fun tracks(vararg values: Output<FilterTrackSelectionArgs>) {
        this.tracks = Output.all(values.asList())
    }

    /**
     * @param values The tracks selection conditions.
     */
    @JvmName("nidoeoxxvccwnuwj")
    public suspend fun tracks(values: List<Output<FilterTrackSelectionArgs>>) {
        this.tracks = Output.all(values)
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("mkwscxkoocqftckv")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The Asset name.
     */
    @JvmName("qhhqmykklsonsemc")
    public suspend fun assetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetName = mapped
    }

    /**
     * @param value The Asset Filter name
     */
    @JvmName("bcxcsbosskcmbtjy")
    public suspend fun filterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterName = mapped
    }

    /**
     * @param value The first quality.
     */
    @JvmName("cqpjvpxiiglnkxxs")
    public suspend fun firstQuality(`value`: FirstQualityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstQuality = mapped
    }

    /**
     * @param argument The first quality.
     */
    @JvmName("hbslivohucvhfxcc")
    public suspend fun firstQuality(argument: suspend FirstQualityArgsBuilder.() -> Unit) {
        val toBeMapped = FirstQualityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.firstQuality = mapped
    }

    /**
     * @param value The presentation time range.
     */
    @JvmName("usernqyxfcfskomo")
    public suspend fun presentationTimeRange(`value`: PresentationTimeRangeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presentationTimeRange = mapped
    }

    /**
     * @param argument The presentation time range.
     */
    @JvmName("agcruqlrahnewpae")
    public suspend
    fun presentationTimeRange(argument: suspend PresentationTimeRangeArgsBuilder.() -> Unit) {
        val toBeMapped = PresentationTimeRangeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.presentationTimeRange = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("wlaofmbcdjqclwyc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tracks selection conditions.
     */
    @JvmName("famrcjgsfrnldofu")
    public suspend fun tracks(`value`: List<FilterTrackSelectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tracks = mapped
    }

    /**
     * @param argument The tracks selection conditions.
     */
    @JvmName("pmabrkyyrsbvqewj")
    public suspend fun tracks(argument: List<suspend FilterTrackSelectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FilterTrackSelectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tracks = mapped
    }

    /**
     * @param argument The tracks selection conditions.
     */
    @JvmName("iwotbiduxrrdgxiu")
    public suspend fun tracks(vararg argument: suspend FilterTrackSelectionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FilterTrackSelectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tracks = mapped
    }

    /**
     * @param argument The tracks selection conditions.
     */
    @JvmName("ohsengswnsbppfhw")
    public suspend fun tracks(argument: suspend FilterTrackSelectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FilterTrackSelectionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.tracks = mapped
    }

    /**
     * @param values The tracks selection conditions.
     */
    @JvmName("gsgwjnromqcfehcn")
    public suspend fun tracks(vararg values: FilterTrackSelectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tracks = mapped
    }

    internal fun build(): AssetFilterArgs = AssetFilterArgs(
        accountName = accountName,
        assetName = assetName,
        filterName = filterName,
        firstQuality = firstQuality,
        presentationTimeRange = presentationTimeRange,
        resourceGroupName = resourceGroupName,
        tracks = tracks,
    )
}
