@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.kotlin.outputs.JobOutputAssetResponse
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.media.kotlin.outputs.JobOutputAssetResponse.Companion.toKotlin as jobOutputAssetResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Job].
 */
@PulumiTagMarker
public class JobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobArgs = JobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobArgsBuilder.() -> Unit) {
        val builder = JobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Job {
        val builtJavaResource = com.pulumi.azurenative.media.Job(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Job(builtJavaResource)
    }
}

/**
 * A Job resource type. The progress and state can be obtained by polling a Job or subscribing to events using EventGrid.
 * Azure REST API version: 2022-07-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create a Job
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.Media.Job("job", new()
 *     {
 *         AccountName = "contosomedia",
 *         CorrelationData =
 *         {
 *             { "Key 2", "Value 2" },
 *             { "key1", "value1" },
 *         },
 *         Input = new AzureNative.Media.Inputs.JobInputAssetArgs
 *         {
 *             AssetName = "job1-InputAsset",
 *             OdataType = "#Microsoft.Media.JobInputAsset",
 *         },
 *         JobName = "job1",
 *         Outputs = new[]
 *         {
 *             {
 *                 { "assetName", "job1-OutputAsset" },
 *                 { "odataType", "#Microsoft.Media.JobOutputAsset" },
 *             },
 *         },
 *         ResourceGroupName = "contosoresources",
 *         TransformName = "exampleTransform",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewJob(ctx, "job", &media.JobArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			CorrelationData: pulumi.StringMap{
 * 				"Key 2": pulumi.String("Value 2"),
 * 				"key1":  pulumi.String("value1"),
 * 			},
 * 			Input: media.JobInputAsset{
 * 				AssetName: "job1-InputAsset",
 * 				OdataType: "#Microsoft.Media.JobInputAsset",
 * 			},
 * 			JobName: pulumi.String("job1"),
 * 			Outputs: []media.JobOutputAssetArgs{
 * 				{
 * 					AssetName: pulumi.String("job1-OutputAsset"),
 * 					OdataType: pulumi.String("#Microsoft.Media.JobOutputAsset"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("contosoresources"),
 * 			TransformName:     pulumi.String("exampleTransform"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.Job;
 * import com.pulumi.azurenative.media.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .accountName("contosomedia")
 *             .correlationData(Map.ofEntries(
 *                 Map.entry("Key 2", "Value 2"),
 *                 Map.entry("key1", "value1")
 *             ))
 *             .input(Map.ofEntries(
 *                 Map.entry("assetName", "job1-InputAsset"),
 *                 Map.entry("odataType", "#Microsoft.Media.JobInputAsset")
 *             ))
 *             .jobName("job1")
 *             .outputs(Map.ofEntries(
 *                 Map.entry("assetName", "job1-OutputAsset"),
 *                 Map.entry("odataType", "#Microsoft.Media.JobOutputAsset")
 *             ))
 *             .resourceGroupName("contosoresources")
 *             .transformName("exampleTransform")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:Job job1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}/jobs/{jobName}
 * ```
 */
public class Job internal constructor(
    override val javaResource: com.pulumi.azurenative.media.Job,
) : KotlinCustomResource(javaResource, JobMapper) {
    /**
     * Customer provided key, value pairs that will be returned in Job and JobOutput state events.
     */
    public val correlationData: Output<Map<String, String>>?
        get() = javaResource.correlationData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The UTC date and time when the customer has created the Job, in 'YYYY-MM-DDThh:mm:ssZ' format.
     */
    public val created: Output<String>
        get() = javaResource.created().applyValue({ args0 -> args0 })

    /**
     * Optional customer supplied description of the Job.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The UTC date and time at which this Job finished processing.
     */
    public val endTime: Output<String>
        get() = javaResource.endTime().applyValue({ args0 -> args0 })

    /**
     * The inputs for the Job.
     */
    public val input: Output<Any>
        get() = javaResource.input().applyValue({ args0 -> args0 })

    /**
     * The UTC date and time when the customer has last updated the Job, in 'YYYY-MM-DDThh:mm:ssZ' format.
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The outputs for the Job.
     */
    public val outputs: Output<List<JobOutputAssetResponse>>
        get() = javaResource.outputs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    jobOutputAssetResponseToKotlin(args0)
                })
            })
        })

    /**
     * Priority with which the job should be processed. Higher priority jobs are processed before lower priority jobs. If not set, the default is normal.
     */
    public val priority: Output<String>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The UTC date and time at which this Job began processing.
     */
    public val startTime: Output<String>
        get() = javaResource.startTime().applyValue({ args0 -> args0 })

    /**
     * The current state of the job.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object JobMapper : ResourceMapper<Job> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.media.Job::class == javaResource::class

    override fun map(javaResource: Resource): Job = Job(
        javaResource as
            com.pulumi.azurenative.media.Job,
    )
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Job].
 */
public suspend fun job(name: String, block: suspend JobResourceBuilder.() -> Unit): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 */
public fun job(name: String): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    return builder.build()
}
