@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.kotlin.outputs.CrossSiteAccessPoliciesResponse
import com.pulumi.azurenative.media.kotlin.outputs.LiveEventEncodingResponse
import com.pulumi.azurenative.media.kotlin.outputs.LiveEventInputResponse
import com.pulumi.azurenative.media.kotlin.outputs.LiveEventPreviewResponse
import com.pulumi.azurenative.media.kotlin.outputs.LiveEventTranscriptionResponse
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.media.kotlin.outputs.CrossSiteAccessPoliciesResponse.Companion.toKotlin as crossSiteAccessPoliciesResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.LiveEventEncodingResponse.Companion.toKotlin as liveEventEncodingResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.LiveEventInputResponse.Companion.toKotlin as liveEventInputResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.LiveEventPreviewResponse.Companion.toKotlin as liveEventPreviewResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.LiveEventTranscriptionResponse.Companion.toKotlin as liveEventTranscriptionResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [LiveEvent].
 */
@PulumiTagMarker
public class LiveEventResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LiveEventArgs = LiveEventArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LiveEventArgsBuilder.() -> Unit) {
        val builder = LiveEventArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LiveEvent {
        val builtJavaResource = com.pulumi.azurenative.media.LiveEvent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LiveEvent(builtJavaResource)
    }
}

/**
 * The live event.
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2018-06-01-preview, 2019-05-01-preview.
 * ## Example Usage
 * ### Create a LiveEvent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var liveEvent = new AzureNative.Media.LiveEvent("liveEvent", new()
 *     {
 *         AccountName = "slitestmedia10",
 *         Description = "test event 1",
 *         Input = new AzureNative.Media.Inputs.LiveEventInputArgs
 *         {
 *             AccessControl = new AzureNative.Media.Inputs.LiveEventInputAccessControlArgs
 *             {
 *                 Ip = new AzureNative.Media.Inputs.IPAccessControlArgs
 *                 {
 *                     Allow = new[]
 *                     {
 *                         new AzureNative.Media.Inputs.IPRangeArgs
 *                         {
 *                             Address = "0.0.0.0",
 *                             Name = "AllowAll",
 *                             SubnetPrefixLength = 0,
 *                         },
 *                     },
 *                 },
 *             },
 *             KeyFrameIntervalDuration = "PT6S",
 *             StreamingProtocol = "RTMP",
 *         },
 *         LiveEventName = "myLiveEvent1",
 *         Location = "West US",
 *         Preview = new AzureNative.Media.Inputs.LiveEventPreviewArgs
 *         {
 *             AccessControl = new AzureNative.Media.Inputs.LiveEventPreviewAccessControlArgs
 *             {
 *                 Ip = new AzureNative.Media.Inputs.IPAccessControlArgs
 *                 {
 *                     Allow = new[]
 *                     {
 *                         new AzureNative.Media.Inputs.IPRangeArgs
 *                         {
 *                             Address = "0.0.0.0",
 *                             Name = "AllowAll",
 *                             SubnetPrefixLength = 0,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "mediaresources",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := media.NewLiveEvent(ctx, "liveEvent", &media.LiveEventArgs{
 * AccountName: pulumi.String("slitestmedia10"),
 * Description: pulumi.String("test event 1"),
 * Input: media.LiveEventInputResponse{
 * AccessControl: interface{}{
 * Ip: interface{}{
 * Allow: media.IPRangeArray{
 * &media.IPRangeArgs{
 * Address: pulumi.String("0.0.0.0"),
 * Name: pulumi.String("AllowAll"),
 * SubnetPrefixLength: pulumi.Int(0),
 * },
 * },
 * },
 * },
 * KeyFrameIntervalDuration: pulumi.String("PT6S"),
 * StreamingProtocol: pulumi.String("RTMP"),
 * },
 * LiveEventName: pulumi.String("myLiveEvent1"),
 * Location: pulumi.String("West US"),
 * Preview: media.LiveEventPreviewResponse{
 * AccessControl: interface{}{
 * Ip: interface{}{
 * Allow: media.IPRangeArray{
 * &media.IPRangeArgs{
 * Address: pulumi.String("0.0.0.0"),
 * Name: pulumi.String("AllowAll"),
 * SubnetPrefixLength: pulumi.Int(0),
 * },
 * },
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("mediaresources"),
 * Tags: pulumi.StringMap{
 * "tag1": pulumi.String("value1"),
 * "tag2": pulumi.String("value2"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.LiveEvent;
 * import com.pulumi.azurenative.media.LiveEventArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var liveEvent = new LiveEvent("liveEvent", LiveEventArgs.builder()
 *             .accountName("slitestmedia10")
 *             .description("test event 1")
 *             .input(Map.ofEntries(
 *                 Map.entry("accessControl", Map.of("ip", Map.of("allow", Map.ofEntries(
 *                     Map.entry("address", "0.0.0.0"),
 *                     Map.entry("name", "AllowAll"),
 *                     Map.entry("subnetPrefixLength", 0)
 *                 )))),
 *                 Map.entry("keyFrameIntervalDuration", "PT6S"),
 *                 Map.entry("streamingProtocol", "RTMP")
 *             ))
 *             .liveEventName("myLiveEvent1")
 *             .location("West US")
 *             .preview(Map.of("accessControl", Map.of("ip", Map.of("allow", Map.ofEntries(
 *                 Map.entry("address", "0.0.0.0"),
 *                 Map.entry("name", "AllowAll"),
 *                 Map.entry("subnetPrefixLength", 0)
 *             )))))
 *             .resourceGroupName("mediaresources")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:LiveEvent myLiveEvent1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}
 * ```
 */
public class LiveEvent internal constructor(
    override val javaResource: com.pulumi.azurenative.media.LiveEvent,
) : KotlinCustomResource(javaResource, LiveEventMapper) {
    /**
     * The creation time for the live event
     */
    public val created: Output<String>
        get() = javaResource.created().applyValue({ args0 -> args0 })

    /**
     * Live event cross site access policies.
     */
    public val crossSiteAccessPolicies: Output<CrossSiteAccessPoliciesResponse>?
        get() = javaResource.crossSiteAccessPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> crossSiteAccessPoliciesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A description for the live event.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Encoding settings for the live event. It configures whether a live encoder is used for the live event and settings for the live encoder if it is used.
     */
    public val encoding: Output<LiveEventEncodingResponse>?
        get() = javaResource.encoding().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    liveEventEncodingResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * When useStaticHostname is set to true, the hostnamePrefix specifies the first part of the hostname assigned to the live event preview and ingest endpoints. The final hostname would be a combination of this prefix, the media service account name and a short code for the Azure Media Services data center.
     */
    public val hostnamePrefix: Output<String>?
        get() = javaResource.hostnamePrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Live event input settings. It defines how the live event receives input from a contribution encoder.
     */
    public val input: Output<LiveEventInputResponse>
        get() = javaResource.input().applyValue({ args0 ->
            args0.let({ args0 ->
                liveEventInputResponseToKotlin(args0)
            })
        })

    /**
     * The last modified time of the live event.
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Live event preview settings. Preview allows live event producers to preview the live streaming content without creating any live output.
     */
    public val preview: Output<LiveEventPreviewResponse>?
        get() = javaResource.preview().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    liveEventPreviewResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the live event.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource state of the live event. See https://go.microsoft.com/fwlink/?linkid=2139012 for more information.
     */
    public val resourceState: Output<String>
        get() = javaResource.resourceState().applyValue({ args0 -> args0 })

    /**
     * The options to use for the LiveEvent. This value is specified at creation time and cannot be updated. The valid values for the array entry values are 'Default' and 'LowLatency'.
     */
    public val streamOptions: Output<List<String>>?
        get() = javaResource.streamOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Live transcription settings for the live event. See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature.
     */
    public val transcriptions: Output<List<LiveEventTranscriptionResponse>>?
        get() = javaResource.transcriptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        liveEventTranscriptionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Specifies whether a static hostname would be assigned to the live event preview and ingest endpoints. This value can only be updated if the live event is in Standby state
     */
    public val useStaticHostname: Output<Boolean>?
        get() = javaResource.useStaticHostname().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object LiveEventMapper : ResourceMapper<LiveEvent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.media.LiveEvent::class == javaResource::class

    override fun map(javaResource: Resource): LiveEvent = LiveEvent(
        javaResource as
            com.pulumi.azurenative.media.LiveEvent,
    )
}

/**
 * @see [LiveEvent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LiveEvent].
 */
public suspend fun liveEvent(name: String, block: suspend LiveEventResourceBuilder.() -> Unit):
    LiveEvent {
    val builder = LiveEventResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LiveEvent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun liveEvent(name: String): LiveEvent {
    val builder = LiveEventResourceBuilder()
    builder.name(name)
    return builder.build()
}
