@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.LiveEventArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.StreamOptionsFlag
import com.pulumi.azurenative.media.kotlin.inputs.CrossSiteAccessPoliciesArgs
import com.pulumi.azurenative.media.kotlin.inputs.CrossSiteAccessPoliciesArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.LiveEventEncodingArgs
import com.pulumi.azurenative.media.kotlin.inputs.LiveEventEncodingArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.LiveEventInputArgs
import com.pulumi.azurenative.media.kotlin.inputs.LiveEventInputArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.LiveEventPreviewArgs
import com.pulumi.azurenative.media.kotlin.inputs.LiveEventPreviewArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.LiveEventTranscriptionArgs
import com.pulumi.azurenative.media.kotlin.inputs.LiveEventTranscriptionArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The live event.
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2018-06-01-preview, 2019-05-01-preview.
 * ## Example Usage
 * ### Create a LiveEvent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var liveEvent = new AzureNative.Media.LiveEvent("liveEvent", new()
 *     {
 *         AccountName = "slitestmedia10",
 *         Description = "test event 1",
 *         Input = new AzureNative.Media.Inputs.LiveEventInputArgs
 *         {
 *             AccessControl = new AzureNative.Media.Inputs.LiveEventInputAccessControlArgs
 *             {
 *                 Ip = new AzureNative.Media.Inputs.IPAccessControlArgs
 *                 {
 *                     Allow = new[]
 *                     {
 *                         new AzureNative.Media.Inputs.IPRangeArgs
 *                         {
 *                             Address = "0.0.0.0",
 *                             Name = "AllowAll",
 *                             SubnetPrefixLength = 0,
 *                         },
 *                     },
 *                 },
 *             },
 *             KeyFrameIntervalDuration = "PT6S",
 *             StreamingProtocol = "RTMP",
 *         },
 *         LiveEventName = "myLiveEvent1",
 *         Location = "West US",
 *         Preview = new AzureNative.Media.Inputs.LiveEventPreviewArgs
 *         {
 *             AccessControl = new AzureNative.Media.Inputs.LiveEventPreviewAccessControlArgs
 *             {
 *                 Ip = new AzureNative.Media.Inputs.IPAccessControlArgs
 *                 {
 *                     Allow = new[]
 *                     {
 *                         new AzureNative.Media.Inputs.IPRangeArgs
 *                         {
 *                             Address = "0.0.0.0",
 *                             Name = "AllowAll",
 *                             SubnetPrefixLength = 0,
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "mediaresources",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := media.NewLiveEvent(ctx, "liveEvent", &media.LiveEventArgs{
 * AccountName: pulumi.String("slitestmedia10"),
 * Description: pulumi.String("test event 1"),
 * Input: media.LiveEventInputResponse{
 * AccessControl: interface{}{
 * Ip: interface{}{
 * Allow: media.IPRangeArray{
 * &media.IPRangeArgs{
 * Address: pulumi.String("0.0.0.0"),
 * Name: pulumi.String("AllowAll"),
 * SubnetPrefixLength: pulumi.Int(0),
 * },
 * },
 * },
 * },
 * KeyFrameIntervalDuration: pulumi.String("PT6S"),
 * StreamingProtocol: pulumi.String("RTMP"),
 * },
 * LiveEventName: pulumi.String("myLiveEvent1"),
 * Location: pulumi.String("West US"),
 * Preview: media.LiveEventPreviewResponse{
 * AccessControl: interface{}{
 * Ip: interface{}{
 * Allow: media.IPRangeArray{
 * &media.IPRangeArgs{
 * Address: pulumi.String("0.0.0.0"),
 * Name: pulumi.String("AllowAll"),
 * SubnetPrefixLength: pulumi.Int(0),
 * },
 * },
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("mediaresources"),
 * Tags: pulumi.StringMap{
 * "tag1": pulumi.String("value1"),
 * "tag2": pulumi.String("value2"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.LiveEvent;
 * import com.pulumi.azurenative.media.LiveEventArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var liveEvent = new LiveEvent("liveEvent", LiveEventArgs.builder()
 *             .accountName("slitestmedia10")
 *             .description("test event 1")
 *             .input(Map.ofEntries(
 *                 Map.entry("accessControl", Map.of("ip", Map.of("allow", Map.ofEntries(
 *                     Map.entry("address", "0.0.0.0"),
 *                     Map.entry("name", "AllowAll"),
 *                     Map.entry("subnetPrefixLength", 0)
 *                 )))),
 *                 Map.entry("keyFrameIntervalDuration", "PT6S"),
 *                 Map.entry("streamingProtocol", "RTMP")
 *             ))
 *             .liveEventName("myLiveEvent1")
 *             .location("West US")
 *             .preview(Map.of("accessControl", Map.of("ip", Map.of("allow", Map.ofEntries(
 *                 Map.entry("address", "0.0.0.0"),
 *                 Map.entry("name", "AllowAll"),
 *                 Map.entry("subnetPrefixLength", 0)
 *             )))))
 *             .resourceGroupName("mediaresources")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:LiveEvent myLiveEvent1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/liveEvents/{liveEventName}
 * ```
 * @property accountName The Media Services account name.
 * @property autoStart The flag indicates if the resource should be automatically started on creation.
 * @property crossSiteAccessPolicies Live event cross site access policies.
 * @property description A description for the live event.
 * @property encoding Encoding settings for the live event. It configures whether a live encoder is used for the live event and settings for the live encoder if it is used.
 * @property hostnamePrefix When useStaticHostname is set to true, the hostnamePrefix specifies the first part of the hostname assigned to the live event preview and ingest endpoints. The final hostname would be a combination of this prefix, the media service account name and a short code for the Azure Media Services data center.
 * @property input Live event input settings. It defines how the live event receives input from a contribution encoder.
 * @property liveEventName The name of the live event, maximum length is 32.
 * @property location The geo-location where the resource lives
 * @property preview Live event preview settings. Preview allows live event producers to preview the live streaming content without creating any live output.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property streamOptions The options to use for the LiveEvent. This value is specified at creation time and cannot be updated. The valid values for the array entry values are 'Default' and 'LowLatency'.
 * @property tags Resource tags.
 * @property transcriptions Live transcription settings for the live event. See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature.
 * @property useStaticHostname Specifies whether a static hostname would be assigned to the live event preview and ingest endpoints. This value can only be updated if the live event is in Standby state
 */
public data class LiveEventArgs(
    public val accountName: Output<String>? = null,
    public val autoStart: Output<Boolean>? = null,
    public val crossSiteAccessPolicies: Output<CrossSiteAccessPoliciesArgs>? = null,
    public val description: Output<String>? = null,
    public val encoding: Output<LiveEventEncodingArgs>? = null,
    public val hostnamePrefix: Output<String>? = null,
    public val input: Output<LiveEventInputArgs>? = null,
    public val liveEventName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val preview: Output<LiveEventPreviewArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val streamOptions: Output<List<Either<String, StreamOptionsFlag>>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transcriptions: Output<List<LiveEventTranscriptionArgs>>? = null,
    public val useStaticHostname: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.LiveEventArgs> {
    override fun toJava(): com.pulumi.azurenative.media.LiveEventArgs =
        com.pulumi.azurenative.media.LiveEventArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .autoStart(autoStart?.applyValue({ args0 -> args0 }))
            .crossSiteAccessPolicies(
                crossSiteAccessPolicies?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .encoding(encoding?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hostnamePrefix(hostnamePrefix?.applyValue({ args0 -> args0 }))
            .input(input?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .liveEventName(liveEventName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .preview(preview?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .streamOptions(
                streamOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transcriptions(
                transcriptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .useStaticHostname(useStaticHostname?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LiveEventArgs].
 */
@PulumiTagMarker
public class LiveEventArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var autoStart: Output<Boolean>? = null

    private var crossSiteAccessPolicies: Output<CrossSiteAccessPoliciesArgs>? = null

    private var description: Output<String>? = null

    private var encoding: Output<LiveEventEncodingArgs>? = null

    private var hostnamePrefix: Output<String>? = null

    private var input: Output<LiveEventInputArgs>? = null

    private var liveEventName: Output<String>? = null

    private var location: Output<String>? = null

    private var preview: Output<LiveEventPreviewArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var streamOptions: Output<List<Either<String, StreamOptionsFlag>>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transcriptions: Output<List<LiveEventTranscriptionArgs>>? = null

    private var useStaticHostname: Output<Boolean>? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("lksxbntcadwsegam")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The flag indicates if the resource should be automatically started on creation.
     */
    @JvmName("rmrklrppqbvuduqe")
    public suspend fun autoStart(`value`: Output<Boolean>) {
        this.autoStart = value
    }

    /**
     * @param value Live event cross site access policies.
     */
    @JvmName("fjrhybgutisnbxqv")
    public suspend fun crossSiteAccessPolicies(`value`: Output<CrossSiteAccessPoliciesArgs>) {
        this.crossSiteAccessPolicies = value
    }

    /**
     * @param value A description for the live event.
     */
    @JvmName("cfdptyiiljwyuogr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Encoding settings for the live event. It configures whether a live encoder is used for the live event and settings for the live encoder if it is used.
     */
    @JvmName("jjfuapfawjyxosaw")
    public suspend fun encoding(`value`: Output<LiveEventEncodingArgs>) {
        this.encoding = value
    }

    /**
     * @param value When useStaticHostname is set to true, the hostnamePrefix specifies the first part of the hostname assigned to the live event preview and ingest endpoints. The final hostname would be a combination of this prefix, the media service account name and a short code for the Azure Media Services data center.
     */
    @JvmName("ewcjdwmhydfnwxqj")
    public suspend fun hostnamePrefix(`value`: Output<String>) {
        this.hostnamePrefix = value
    }

    /**
     * @param value Live event input settings. It defines how the live event receives input from a contribution encoder.
     */
    @JvmName("rrkaexmblukkxcys")
    public suspend fun input(`value`: Output<LiveEventInputArgs>) {
        this.input = value
    }

    /**
     * @param value The name of the live event, maximum length is 32.
     */
    @JvmName("pjffphixadvedxhn")
    public suspend fun liveEventName(`value`: Output<String>) {
        this.liveEventName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wfavbutkpfghnsml")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Live event preview settings. Preview allows live event producers to preview the live streaming content without creating any live output.
     */
    @JvmName("btmwdkhxixuqcios")
    public suspend fun preview(`value`: Output<LiveEventPreviewArgs>) {
        this.preview = value
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("vgtfhgowovggxauo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The options to use for the LiveEvent. This value is specified at creation time and cannot be updated. The valid values for the array entry values are 'Default' and 'LowLatency'.
     */
    @JvmName("xjekbllnrpepmrnv")
    public suspend fun streamOptions(`value`: Output<List<Either<String, StreamOptionsFlag>>>) {
        this.streamOptions = value
    }

    @JvmName("awkshgreffaavxaj")
    public suspend fun streamOptions(vararg values: Output<Either<String, StreamOptionsFlag>>) {
        this.streamOptions = Output.all(values.asList())
    }

    /**
     * @param values The options to use for the LiveEvent. This value is specified at creation time and cannot be updated. The valid values for the array entry values are 'Default' and 'LowLatency'.
     */
    @JvmName("qmvunvidxhouqsby")
    public suspend fun streamOptions(values: List<Output<Either<String, StreamOptionsFlag>>>) {
        this.streamOptions = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ghtmnxfsnvixcvij")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Live transcription settings for the live event. See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature.
     */
    @JvmName("xfpdfpjrujplkmhn")
    public suspend fun transcriptions(`value`: Output<List<LiveEventTranscriptionArgs>>) {
        this.transcriptions = value
    }

    @JvmName("ajehkasjqvnomqrs")
    public suspend fun transcriptions(vararg values: Output<LiveEventTranscriptionArgs>) {
        this.transcriptions = Output.all(values.asList())
    }

    /**
     * @param values Live transcription settings for the live event. See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature.
     */
    @JvmName("mdtnychykvlbmuep")
    public suspend fun transcriptions(values: List<Output<LiveEventTranscriptionArgs>>) {
        this.transcriptions = Output.all(values)
    }

    /**
     * @param value Specifies whether a static hostname would be assigned to the live event preview and ingest endpoints. This value can only be updated if the live event is in Standby state
     */
    @JvmName("xwlloqqfiptwccjh")
    public suspend fun useStaticHostname(`value`: Output<Boolean>) {
        this.useStaticHostname = value
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("sjuwtngthvrgrxfm")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The flag indicates if the resource should be automatically started on creation.
     */
    @JvmName("vipnslldmelhequx")
    public suspend fun autoStart(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoStart = mapped
    }

    /**
     * @param value Live event cross site access policies.
     */
    @JvmName("lyftwpscariddtau")
    public suspend fun crossSiteAccessPolicies(`value`: CrossSiteAccessPoliciesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossSiteAccessPolicies = mapped
    }

    /**
     * @param argument Live event cross site access policies.
     */
    @JvmName("ghmrqnvjhfonsxne")
    public suspend
    fun crossSiteAccessPolicies(argument: suspend CrossSiteAccessPoliciesArgsBuilder.() -> Unit) {
        val toBeMapped = CrossSiteAccessPoliciesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.crossSiteAccessPolicies = mapped
    }

    /**
     * @param value A description for the live event.
     */
    @JvmName("nfnjfcgnkjmjuxfg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Encoding settings for the live event. It configures whether a live encoder is used for the live event and settings for the live encoder if it is used.
     */
    @JvmName("lngcliieahjrnxpc")
    public suspend fun encoding(`value`: LiveEventEncodingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encoding = mapped
    }

    /**
     * @param argument Encoding settings for the live event. It configures whether a live encoder is used for the live event and settings for the live encoder if it is used.
     */
    @JvmName("anhvbpofchvuqqwo")
    public suspend fun encoding(argument: suspend LiveEventEncodingArgsBuilder.() -> Unit) {
        val toBeMapped = LiveEventEncodingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encoding = mapped
    }

    /**
     * @param value When useStaticHostname is set to true, the hostnamePrefix specifies the first part of the hostname assigned to the live event preview and ingest endpoints. The final hostname would be a combination of this prefix, the media service account name and a short code for the Azure Media Services data center.
     */
    @JvmName("hdxifdryskkeuipf")
    public suspend fun hostnamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostnamePrefix = mapped
    }

    /**
     * @param value Live event input settings. It defines how the live event receives input from a contribution encoder.
     */
    @JvmName("ulwyxxgyifmrhjpw")
    public suspend fun input(`value`: LiveEventInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param argument Live event input settings. It defines how the live event receives input from a contribution encoder.
     */
    @JvmName("qcdopjamnmvbxyvj")
    public suspend fun input(argument: suspend LiveEventInputArgsBuilder.() -> Unit) {
        val toBeMapped = LiveEventInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.input = mapped
    }

    /**
     * @param value The name of the live event, maximum length is 32.
     */
    @JvmName("foefbqlqtnwjclmp")
    public suspend fun liveEventName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.liveEventName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ormtpcpwsupsumrn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Live event preview settings. Preview allows live event producers to preview the live streaming content without creating any live output.
     */
    @JvmName("cltlakdrjtyjkcoa")
    public suspend fun preview(`value`: LiveEventPreviewArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preview = mapped
    }

    /**
     * @param argument Live event preview settings. Preview allows live event producers to preview the live streaming content without creating any live output.
     */
    @JvmName("ppohjgqpbxiosfoh")
    public suspend fun preview(argument: suspend LiveEventPreviewArgsBuilder.() -> Unit) {
        val toBeMapped = LiveEventPreviewArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.preview = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("nndgsudxmfibpklq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The options to use for the LiveEvent. This value is specified at creation time and cannot be updated. The valid values for the array entry values are 'Default' and 'LowLatency'.
     */
    @JvmName("kuijvrrrafwimwmu")
    public suspend fun streamOptions(`value`: List<Either<String, StreamOptionsFlag>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamOptions = mapped
    }

    /**
     * @param values The options to use for the LiveEvent. This value is specified at creation time and cannot be updated. The valid values for the array entry values are 'Default' and 'LowLatency'.
     */
    @JvmName("jobwchtqbqlpfvbk")
    public suspend fun streamOptions(vararg values: Either<String, StreamOptionsFlag>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamOptions = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jmpdoiwtxtramelk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dxjcgkeftpeotraj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Live transcription settings for the live event. See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature.
     */
    @JvmName("totwbhtjhuwnlxas")
    public suspend fun transcriptions(`value`: List<LiveEventTranscriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transcriptions = mapped
    }

    /**
     * @param argument Live transcription settings for the live event. See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature.
     */
    @JvmName("jecwnequqnamexva")
    public suspend
    fun transcriptions(argument: List<suspend LiveEventTranscriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LiveEventTranscriptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.transcriptions = mapped
    }

    /**
     * @param argument Live transcription settings for the live event. See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature.
     */
    @JvmName("xldebueqmqejfxkt")
    public suspend fun transcriptions(
        vararg
        argument: suspend LiveEventTranscriptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LiveEventTranscriptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.transcriptions = mapped
    }

    /**
     * @param argument Live transcription settings for the live event. See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature.
     */
    @JvmName("lmsiueakrcfovmgh")
    public suspend
    fun transcriptions(argument: suspend LiveEventTranscriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LiveEventTranscriptionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.transcriptions = mapped
    }

    /**
     * @param values Live transcription settings for the live event. See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature.
     */
    @JvmName("jvoqpyfdxgbevypl")
    public suspend fun transcriptions(vararg values: LiveEventTranscriptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transcriptions = mapped
    }

    /**
     * @param value Specifies whether a static hostname would be assigned to the live event preview and ingest endpoints. This value can only be updated if the live event is in Standby state
     */
    @JvmName("ejcfwuqwpdnjnios")
    public suspend fun useStaticHostname(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useStaticHostname = mapped
    }

    internal fun build(): LiveEventArgs = LiveEventArgs(
        accountName = accountName,
        autoStart = autoStart,
        crossSiteAccessPolicies = crossSiteAccessPolicies,
        description = description,
        encoding = encoding,
        hostnamePrefix = hostnamePrefix,
        input = input,
        liveEventName = liveEventName,
        location = location,
        preview = preview,
        resourceGroupName = resourceGroupName,
        streamOptions = streamOptions,
        tags = tags,
        transcriptions = transcriptions,
        useStaticHostname = useStaticHostname,
    )
}
