@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.MediaGraphArgs.builder
import com.pulumi.azurenative.media.kotlin.inputs.MediaGraphAssetSinkArgs
import com.pulumi.azurenative.media.kotlin.inputs.MediaGraphAssetSinkArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.MediaGraphRtspSourceArgs
import com.pulumi.azurenative.media.kotlin.inputs.MediaGraphRtspSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Media Graph.
 * Azure REST API version: 2020-02-01-preview. Prior API version in Azure Native 1.x: 2020-02-01-preview.
 * ## Example Usage
 * ### Create or update a Media Graph with a clear RTSP Source
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mediaGraph = new AzureNative.Media.MediaGraph("mediaGraph", new()
 *     {
 *         AccountName = "contosomedia",
 *         Description = "updated description",
 *         MediaGraphName = "SampleMediaGraph",
 *         ResourceGroupName = "contoso",
 *         Sinks = new[]
 *         {
 *             {
 *                 { "assetName", "SampleAsset" },
 *                 { "inputs", new[]
 *                 {
 *                     "rtspSource",
 *                 } },
 *                 { "name", "AssetSink" },
 *                 { "odataType", "#Microsoft.Media.MediaGraphAssetSink" },
 *             },
 *         },
 *         Sources = new[]
 *         {
 *             {
 *                 { "endpoint", new AzureNative.Media.Inputs.MediaGraphClearEndpointArgs
 *                 {
 *                     Credentials = new AzureNative.Media.Inputs.MediaGraphUsernamePasswordCredentialsArgs
 *                     {
 *                         OdataType = "#Microsoft.Media.MediaGraphUsernamePasswordCredentials",
 *                         Password = "examplepassword",
 *                         Username = "exampleusername",
 *                     },
 *                     OdataType = "#Microsoft.Media.MediaGraphClearEndpoint",
 *                     Url = "rtsp://contoso.com:554/stream1",
 *                 } },
 *                 { "name", "rtspSource" },
 *                 { "odataType", "#Microsoft.Media.MediaGraphRtspSource" },
 *                 { "transport", "Http" },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewMediaGraph(ctx, "mediaGraph", &media.MediaGraphArgs{
 * 			AccountName:       pulumi.String("contosomedia"),
 * 			Description:       pulumi.String("updated description"),
 * 			MediaGraphName:    pulumi.String("SampleMediaGraph"),
 * 			ResourceGroupName: pulumi.String("contoso"),
 * 			Sinks: []media.MediaGraphAssetSinkArgs{
 * 				{
 * 					AssetName: pulumi.String("SampleAsset"),
 * 					Inputs: pulumi.StringArray{
 * 						pulumi.String("rtspSource"),
 * 					},
 * 					Name:      pulumi.String("AssetSink"),
 * 					OdataType: pulumi.String("#Microsoft.Media.MediaGraphAssetSink"),
 * 				},
 * 			},
 * 			Sources: []media.MediaGraphRtspSourceArgs{
 * 				{
 * 					Endpoint: {
 * 						Credentials: {
 * 							OdataType: "#Microsoft.Media.MediaGraphUsernamePasswordCredentials",
 * 							Password:  "examplepassword",
 * 							Username:  "exampleusername",
 * 						},
 * 						OdataType: "#Microsoft.Media.MediaGraphClearEndpoint",
 * 						Url:       "rtsp://contoso.com:554/stream1",
 * 					},
 * 					Name:      pulumi.String("rtspSource"),
 * 					OdataType: pulumi.String("#Microsoft.Media.MediaGraphRtspSource"),
 * 					Transport: pulumi.String("Http"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.MediaGraph;
 * import com.pulumi.azurenative.media.MediaGraphArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mediaGraph = new MediaGraph("mediaGraph", MediaGraphArgs.builder()
 *             .accountName("contosomedia")
 *             .description("updated description")
 *             .mediaGraphName("SampleMediaGraph")
 *             .resourceGroupName("contoso")
 *             .sinks(Map.ofEntries(
 *                 Map.entry("assetName", "SampleAsset"),
 *                 Map.entry("inputs", "rtspSource"),
 *                 Map.entry("name", "AssetSink"),
 *                 Map.entry("odataType", "#Microsoft.Media.MediaGraphAssetSink")
 *             ))
 *             .sources(Map.ofEntries(
 *                 Map.entry("endpoint", Map.ofEntries(
 *                     Map.entry("credentials", Map.ofEntries(
 *                         Map.entry("odataType", "#Microsoft.Media.MediaGraphUsernamePasswordCredentials"),
 *                         Map.entry("password", "examplepassword"),
 *                         Map.entry("username", "exampleusername")
 *                     )),
 *                     Map.entry("odataType", "#Microsoft.Media.MediaGraphClearEndpoint"),
 *                     Map.entry("url", "rtsp://contoso.com:554/stream1")
 *                 )),
 *                 Map.entry("name", "rtspSource"),
 *                 Map.entry("odataType", "#Microsoft.Media.MediaGraphRtspSource"),
 *                 Map.entry("transport", "Http")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a Media Graph with an encrypted RTSP Source
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mediaGraph = new AzureNative.Media.MediaGraph("mediaGraph", new()
 *     {
 *         AccountName = "contosomedia",
 *         Description = "updated description",
 *         MediaGraphName = "SampleMediaGraph",
 *         ResourceGroupName = "contoso",
 *         Sinks = new[]
 *         {
 *             {
 *                 { "assetName", "SampleAsset" },
 *                 { "inputs", new[]
 *                 {
 *                     "rtspSource",
 *                 } },
 *                 { "name", "AssetSink" },
 *                 { "odataType", "#Microsoft.Media.MediaGraphAssetSink" },
 *             },
 *         },
 *         Sources = new[]
 *         {
 *             {
 *                 { "endpoint", new AzureNative.Media.Inputs.MediaGraphTlsEndpointArgs
 *                 {
 *                     Credentials = new AzureNative.Media.Inputs.MediaGraphUsernamePasswordCredentialsArgs
 *                     {
 *                         OdataType = "#Microsoft.Media.MediaGraphUsernamePasswordCredentials",
 *                         Password = "examplepassword",
 *                         Username = "exampleusername",
 *                     },
 *                     OdataType = "#Microsoft.Media.MediaGraphTlsEndpoint",
 *                     TrustedCertificates = new AzureNative.Media.Inputs.MediaGraphPemCertificateListArgs
 *                     {
 *                         Certificates = new[]
 *                         {
 *                             @"-----BEGIN CERTIFICATE-----
 * MIIDhTCCAm2gAwIBAgIUajvPKmoO+8qaO89/ZGATl7ZYnTswDQYJKoZIhvcNAQEL
 * BQAwUTESMBAGA1UECgwJTWljcm9zb2Z0MRQwEgYDVQQLDAtBenVyZSBNZWRpYTEl
 * MCMGA1UEAwwcKFVudHJ1c3RlZCkgVGVzdCBDZXJ0aWZpY2F0ZTAgFw0yMDAyMDYy
 * MTI5MTlaGA8zMDE5MDYwOTIxMjkxOVowUTESMBAGA1UECgwJTWljcm9zb2Z0MRQw
 * EgYDVQQLDAtBenVyZSBNZWRpYTElMCMGA1UEAwwcKFVudHJ1c3RlZCkgVGVzdCBD
 * ZXJ0aWZpY2F0ZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK2lg5ff
 * 7xXPaBZXHl/zrTukdiBtu7BNIOchHba51eloruPRzpvQx7Pedk3CVTut7LYinijf
 * uol0EwkQ2FLt2i2jOqiva9nXR95ujIZHcKsEeMC4RSNSP4++k6SpP8FgyYVdv5ru
 * f8GC+HyYQ4j0TqpR/cJs53l/LGRSldaFZ6fcDde1jeyca4VivAbAH1/WDIOvmjzo
 * 9XIGxZ10VSS5l5+DIgdkJZ+mDMLJIuVZ0YVF16ZGEB3beq1trk5lItvmSjQLTllH
 * qMFm9UGY8jKZSo/BY8ewHEtnGSAFQK0TVuRx1HhUWwu6C9jk+2zmRS2090BNpQWa
 * JMKFJrSPzFDPRX8CAwEAAaNTMFEwHQYDVR0OBBYEFIumbhu0lYk0EFDThEg0yyIn
 * /wZZMB8GA1UdIwQYMBaAFIumbhu0lYk0EFDThEg0yyIn/wZZMA8GA1UdEwEB/wQF
 * MAMBAf8wDQYJKoZIhvcNAQELBQADggEBADUNw+/NGNVtigq9tMJKqlk39MTpDn1s
 * Z1BVIAuAWSQjlevYZJeDIPUiWNWFhRe+xN7oOLnn2+NIXEKKeMSyuPoZYbN0mBkB
 * 99oS3XVipSANpmDvIepNdCrOnjfqDFIifRF1Dqjtb6i1hb6v/qYKVPLQvcrgGur7
 * PKKkAu9p4YRZ3RBdwwaUuMgojrj/l6DGbeJY6IRVnVMY39rryMnZjA5xUlhCu55n
 * oB3t/jsJLwnQN+JbAjLAeuqgOWtgARsEFzvpt+VvDsaj0YLOJPhyJwTvHgaa/slB
 * nECzd3TuyFKYeGssSni/QQ1e7yZcLapQqz66g5otdriw0IRdOfDxm5M=
 * -----END CERTIFICATE-----",
 *                         },
 *                         OdataType = "#Microsoft.Media.MediaGraphPemCertificateList",
 *                     },
 *                     Url = "rtsps://contoso.com:443/stream1",
 *                     ValidationOptions = new AzureNative.Media.Inputs.MediaGraphTlsValidationOptionsArgs
 *                     {
 *                         IgnoreHostname = true,
 *                         IgnoreSignature = false,
 *                     },
 *                 } },
 *                 { "name", "rtspSource" },
 *                 { "odataType", "#Microsoft.Media.MediaGraphRtspSource" },
 *                 { "transport", "Http" },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewMediaGraph(ctx, "mediaGraph", &media.MediaGraphArgs{
 * 			AccountName:       pulumi.String("contosomedia"),
 * 			Description:       pulumi.String("updated description"),
 * 			MediaGraphName:    pulumi.String("SampleMediaGraph"),
 * 			ResourceGroupName: pulumi.String("contoso"),
 * 			Sinks: []media.MediaGraphAssetSinkArgs{
 * 				{
 * 					AssetName: pulumi.String("SampleAsset"),
 * 					Inputs: pulumi.StringArray{
 * 						pulumi.String("rtspSource"),
 * 					},
 * 					Name:      pulumi.String("AssetSink"),
 * 					OdataType: pulumi.String("#Microsoft.Media.MediaGraphAssetSink"),
 * 				},
 * 			},
 * 			Sources: []media.MediaGraphRtspSourceArgs{
 * 				{
 * 					Endpoint: {
 * 						Credentials: {
 * 							OdataType: "#Microsoft.Media.MediaGraphUsernamePasswordCredentials",
 * 							Password:  "examplepassword",
 * 							Username:  "exampleusername",
 * 						},
 * 						OdataType: "#Microsoft.Media.MediaGraphTlsEndpoint",
 * 						TrustedCertificates: {
 * 							Certificates: []string{
 * 								`-----BEGIN CERTIFICATE-----
 * MIIDhTCCAm2gAwIBAgIUajvPKmoO+8qaO89/ZGATl7ZYnTswDQYJKoZIhvcNAQEL
 * BQAwUTESMBAGA1UECgwJTWljcm9zb2Z0MRQwEgYDVQQLDAtBenVyZSBNZWRpYTEl
 * MCMGA1UEAwwcKFVudHJ1c3RlZCkgVGVzdCBDZXJ0aWZpY2F0ZTAgFw0yMDAyMDYy
 * MTI5MTlaGA8zMDE5MDYwOTIxMjkxOVowUTESMBAGA1UECgwJTWljcm9zb2Z0MRQw
 * EgYDVQQLDAtBenVyZSBNZWRpYTElMCMGA1UEAwwcKFVudHJ1c3RlZCkgVGVzdCBD
 * ZXJ0aWZpY2F0ZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK2lg5ff
 * 7xXPaBZXHl/zrTukdiBtu7BNIOchHba51eloruPRzpvQx7Pedk3CVTut7LYinijf
 * uol0EwkQ2FLt2i2jOqiva9nXR95ujIZHcKsEeMC4RSNSP4++k6SpP8FgyYVdv5ru
 * f8GC+HyYQ4j0TqpR/cJs53l/LGRSldaFZ6fcDde1jeyca4VivAbAH1/WDIOvmjzo
 * 9XIGxZ10VSS5l5+DIgdkJZ+mDMLJIuVZ0YVF16ZGEB3beq1trk5lItvmSjQLTllH
 * qMFm9UGY8jKZSo/BY8ewHEtnGSAFQK0TVuRx1HhUWwu6C9jk+2zmRS2090BNpQWa
 * JMKFJrSPzFDPRX8CAwEAAaNTMFEwHQYDVR0OBBYEFIumbhu0lYk0EFDThEg0yyIn
 * /wZZMB8GA1UdIwQYMBaAFIumbhu0lYk0EFDThEg0yyIn/wZZMA8GA1UdEwEB/wQF
 * MAMBAf8wDQYJKoZIhvcNAQELBQADggEBADUNw+/NGNVtigq9tMJKqlk39MTpDn1s
 * Z1BVIAuAWSQjlevYZJeDIPUiWNWFhRe+xN7oOLnn2+NIXEKKeMSyuPoZYbN0mBkB
 * 99oS3XVipSANpmDvIepNdCrOnjfqDFIifRF1Dqjtb6i1hb6v/qYKVPLQvcrgGur7
 * PKKkAu9p4YRZ3RBdwwaUuMgojrj/l6DGbeJY6IRVnVMY39rryMnZjA5xUlhCu55n
 * oB3t/jsJLwnQN+JbAjLAeuqgOWtgARsEFzvpt+VvDsaj0YLOJPhyJwTvHgaa/slB
 * nECzd3TuyFKYeGssSni/QQ1e7yZcLapQqz66g5otdriw0IRdOfDxm5M=
 * -----END CERTIFICATE-----`,
 * 							},
 * 							OdataType: "#Microsoft.Media.MediaGraphPemCertificateList",
 * 						},
 * 						Url: "rtsps://contoso.com:443/stream1",
 * 						ValidationOptions: {
 * 							IgnoreHostname:  true,
 * 							IgnoreSignature: false,
 * 						},
 * 					},
 * 					Name:      pulumi.String("rtspSource"),
 * 					OdataType: pulumi.String("#Microsoft.Media.MediaGraphRtspSource"),
 * 					Transport: pulumi.String("Http"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.MediaGraph;
 * import com.pulumi.azurenative.media.MediaGraphArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mediaGraph = new MediaGraph("mediaGraph", MediaGraphArgs.builder()
 *             .accountName("contosomedia")
 *             .description("updated description")
 *             .mediaGraphName("SampleMediaGraph")
 *             .resourceGroupName("contoso")
 *             .sinks(Map.ofEntries(
 *                 Map.entry("assetName", "SampleAsset"),
 *                 Map.entry("inputs", "rtspSource"),
 *                 Map.entry("name", "AssetSink"),
 *                 Map.entry("odataType", "#Microsoft.Media.MediaGraphAssetSink")
 *             ))
 *             .sources(Map.ofEntries(
 *                 Map.entry("endpoint", Map.ofEntries(
 *                     Map.entry("credentials", Map.ofEntries(
 *                         Map.entry("odataType", "#Microsoft.Media.MediaGraphUsernamePasswordCredentials"),
 *                         Map.entry("password", "examplepassword"),
 *                         Map.entry("username", "exampleusername")
 *                     )),
 *                     Map.entry("odataType", "#Microsoft.Media.MediaGraphTlsEndpoint"),
 *                     Map.entry("trustedCertificates", Map.ofEntries(
 *                         Map.entry("certificates", """
 * -----BEGIN CERTIFICATE-----
 * MIIDhTCCAm2gAwIBAgIUajvPKmoO+8qaO89/ZGATl7ZYnTswDQYJKoZIhvcNAQEL
 * BQAwUTESMBAGA1UECgwJTWljcm9zb2Z0MRQwEgYDVQQLDAtBenVyZSBNZWRpYTEl
 * MCMGA1UEAwwcKFVudHJ1c3RlZCkgVGVzdCBDZXJ0aWZpY2F0ZTAgFw0yMDAyMDYy
 * MTI5MTlaGA8zMDE5MDYwOTIxMjkxOVowUTESMBAGA1UECgwJTWljcm9zb2Z0MRQw
 * EgYDVQQLDAtBenVyZSBNZWRpYTElMCMGA1UEAwwcKFVudHJ1c3RlZCkgVGVzdCBD
 * ZXJ0aWZpY2F0ZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK2lg5ff
 * 7xXPaBZXHl/zrTukdiBtu7BNIOchHba51eloruPRzpvQx7Pedk3CVTut7LYinijf
 * uol0EwkQ2FLt2i2jOqiva9nXR95ujIZHcKsEeMC4RSNSP4++k6SpP8FgyYVdv5ru
 * f8GC+HyYQ4j0TqpR/cJs53l/LGRSldaFZ6fcDde1jeyca4VivAbAH1/WDIOvmjzo
 * 9XIGxZ10VSS5l5+DIgdkJZ+mDMLJIuVZ0YVF16ZGEB3beq1trk5lItvmSjQLTllH
 * qMFm9UGY8jKZSo/BY8ewHEtnGSAFQK0TVuRx1HhUWwu6C9jk+2zmRS2090BNpQWa
 * JMKFJrSPzFDPRX8CAwEAAaNTMFEwHQYDVR0OBBYEFIumbhu0lYk0EFDThEg0yyIn
 * /wZZMB8GA1UdIwQYMBaAFIumbhu0lYk0EFDThEg0yyIn/wZZMA8GA1UdEwEB/wQF
 * MAMBAf8wDQYJKoZIhvcNAQELBQADggEBADUNw+/NGNVtigq9tMJKqlk39MTpDn1s
 * Z1BVIAuAWSQjlevYZJeDIPUiWNWFhRe+xN7oOLnn2+NIXEKKeMSyuPoZYbN0mBkB
 * 99oS3XVipSANpmDvIepNdCrOnjfqDFIifRF1Dqjtb6i1hb6v/qYKVPLQvcrgGur7
 * PKKkAu9p4YRZ3RBdwwaUuMgojrj/l6DGbeJY6IRVnVMY39rryMnZjA5xUlhCu55n
 * oB3t/jsJLwnQN+JbAjLAeuqgOWtgARsEFzvpt+VvDsaj0YLOJPhyJwTvHgaa/slB
 * nECzd3TuyFKYeGssSni/QQ1e7yZcLapQqz66g5otdriw0IRdOfDxm5M=
 * -----END CERTIFICATE-----                        """),
 *                         Map.entry("odataType", "#Microsoft.Media.MediaGraphPemCertificateList")
 *                     )),
 *                     Map.entry("url", "rtsps://contoso.com:443/stream1"),
 *                     Map.entry("validationOptions", Map.ofEntries(
 *                         Map.entry("ignoreHostname", true),
 *                         Map.entry("ignoreSignature", false)
 *                     ))
 *                 )),
 *                 Map.entry("name", "rtspSource"),
 *                 Map.entry("odataType", "#Microsoft.Media.MediaGraphRtspSource"),
 *                 Map.entry("transport", "Http")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:MediaGraph SampleMediaGraph /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/mediaGraphs/{mediaGraphName}
 * ```
 * @property accountName The Media Services account name.
 * @property description Media Graph description.
 * @property mediaGraphName The Media Graph name.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property sinks Media Graph sinks.
 * @property sources Media Graph sources.
 */
public data class MediaGraphArgs(
    public val accountName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val mediaGraphName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sinks: Output<List<MediaGraphAssetSinkArgs>>? = null,
    public val sources: Output<List<MediaGraphRtspSourceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.MediaGraphArgs> {
    override fun toJava(): com.pulumi.azurenative.media.MediaGraphArgs =
        com.pulumi.azurenative.media.MediaGraphArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .mediaGraphName(mediaGraphName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sinks(sinks?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MediaGraphArgs].
 */
@PulumiTagMarker
public class MediaGraphArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var description: Output<String>? = null

    private var mediaGraphName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sinks: Output<List<MediaGraphAssetSinkArgs>>? = null

    private var sources: Output<List<MediaGraphRtspSourceArgs>>? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("wjfdlgyvrwqrdicg")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Media Graph description.
     */
    @JvmName("seygddktxcyfyxpq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Media Graph name.
     */
    @JvmName("mwfradaqgkexymhe")
    public suspend fun mediaGraphName(`value`: Output<String>) {
        this.mediaGraphName = value
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("opesvatefubwqamo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Media Graph sinks.
     */
    @JvmName("nftcyjmhigckwflw")
    public suspend fun sinks(`value`: Output<List<MediaGraphAssetSinkArgs>>) {
        this.sinks = value
    }

    @JvmName("qtvstrcisyhmhgcs")
    public suspend fun sinks(vararg values: Output<MediaGraphAssetSinkArgs>) {
        this.sinks = Output.all(values.asList())
    }

    /**
     * @param values Media Graph sinks.
     */
    @JvmName("ipvrphiwrsjotddu")
    public suspend fun sinks(values: List<Output<MediaGraphAssetSinkArgs>>) {
        this.sinks = Output.all(values)
    }

    /**
     * @param value Media Graph sources.
     */
    @JvmName("mkeugkjmdsgnxviy")
    public suspend fun sources(`value`: Output<List<MediaGraphRtspSourceArgs>>) {
        this.sources = value
    }

    @JvmName("osvmnunqbpjnaoxk")
    public suspend fun sources(vararg values: Output<MediaGraphRtspSourceArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values Media Graph sources.
     */
    @JvmName("sgheopffhnnkoyqq")
    public suspend fun sources(values: List<Output<MediaGraphRtspSourceArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("vnpgksxdntwphsxr")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Media Graph description.
     */
    @JvmName("caxkxwulpichakoc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Media Graph name.
     */
    @JvmName("ogiwvsmueggwsani")
    public suspend fun mediaGraphName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaGraphName = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("wtohpvopikfdenhy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Media Graph sinks.
     */
    @JvmName("boedcvbtqkjkvbed")
    public suspend fun sinks(`value`: List<MediaGraphAssetSinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinks = mapped
    }

    /**
     * @param argument Media Graph sinks.
     */
    @JvmName("hejcpsadctmcuqbl")
    public suspend fun sinks(argument: List<suspend MediaGraphAssetSinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MediaGraphAssetSinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param argument Media Graph sinks.
     */
    @JvmName("mxcvxdhnjqulyixt")
    public suspend fun sinks(vararg argument: suspend MediaGraphAssetSinkArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MediaGraphAssetSinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param argument Media Graph sinks.
     */
    @JvmName("rkmkbcrkyvammsce")
    public suspend fun sinks(argument: suspend MediaGraphAssetSinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MediaGraphAssetSinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param values Media Graph sinks.
     */
    @JvmName("easkalcrtyaiaaow")
    public suspend fun sinks(vararg values: MediaGraphAssetSinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sinks = mapped
    }

    /**
     * @param value Media Graph sources.
     */
    @JvmName("ahbqgobmauokllwu")
    public suspend fun sources(`value`: List<MediaGraphRtspSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument Media Graph sources.
     */
    @JvmName("inxoxtyiqqpidxqe")
    public suspend fun sources(argument: List<suspend MediaGraphRtspSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MediaGraphRtspSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument Media Graph sources.
     */
    @JvmName("cosgegylwwkgqqbn")
    public suspend fun sources(vararg argument: suspend MediaGraphRtspSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MediaGraphRtspSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument Media Graph sources.
     */
    @JvmName("uqcyctoyinxvxjvn")
    public suspend fun sources(argument: suspend MediaGraphRtspSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MediaGraphRtspSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values Media Graph sources.
     */
    @JvmName("jiiknkoxdaajbcde")
    public suspend fun sources(vararg values: MediaGraphRtspSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    internal fun build(): MediaGraphArgs = MediaGraphArgs(
        accountName = accountName,
        description = description,
        mediaGraphName = mediaGraphName,
        resourceGroupName = resourceGroupName,
        sinks = sinks,
        sources = sources,
    )
}
