@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.StreamingEndpointArgs.builder
import com.pulumi.azurenative.media.kotlin.inputs.ArmStreamingEndpointCurrentSkuArgs
import com.pulumi.azurenative.media.kotlin.inputs.ArmStreamingEndpointCurrentSkuArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.CrossSiteAccessPoliciesArgs
import com.pulumi.azurenative.media.kotlin.inputs.CrossSiteAccessPoliciesArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.StreamingEndpointAccessControlArgs
import com.pulumi.azurenative.media.kotlin.inputs.StreamingEndpointAccessControlArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The streaming endpoint.
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * Other available API versions: 2018-06-01-preview.
 * ## Example Usage
 * ### Create a streaming endpoint
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingEndpoint = new AzureNative.Media.StreamingEndpoint("streamingEndpoint", new()
 *     {
 *         AccessControl = new AzureNative.Media.Inputs.StreamingEndpointAccessControlArgs
 *         {
 *             Akamai = new AzureNative.Media.Inputs.AkamaiAccessControlArgs
 *             {
 *                 AkamaiSignatureHeaderAuthenticationKeyList = new[]
 *                 {
 *                     new AzureNative.Media.Inputs.AkamaiSignatureHeaderAuthenticationKeyArgs
 *                     {
 *                         Base64Key = "dGVzdGlkMQ==",
 *                         Expiration = "2029-12-31T16:00:00-08:00",
 *                         Identifier = "id1",
 *                     },
 *                     new AzureNative.Media.Inputs.AkamaiSignatureHeaderAuthenticationKeyArgs
 *                     {
 *                         Base64Key = "dGVzdGlkMQ==",
 *                         Expiration = "2030-12-31T16:00:00-08:00",
 *                         Identifier = "id2",
 *                     },
 *                 },
 *             },
 *             Ip = new AzureNative.Media.Inputs.IPAccessControlArgs
 *             {
 *                 Allow = new[]
 *                 {
 *                     new AzureNative.Media.Inputs.IPRangeArgs
 *                     {
 *                         Address = "192.168.1.1",
 *                         Name = "AllowedIp",
 *                     },
 *                 },
 *             },
 *         },
 *         AccountName = "slitestmedia10",
 *         AvailabilitySetName = "availableset",
 *         CdnEnabled = false,
 *         Description = "test event 1",
 *         Location = "West US",
 *         ResourceGroupName = "mediaresources",
 *         ScaleUnits = 1,
 *         StreamingEndpointName = "myStreamingEndpoint1",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := media.NewStreamingEndpoint(ctx, "streamingEndpoint", &media.StreamingEndpointArgs{
 * AccessControl: media.StreamingEndpointAccessControlResponse{
 * Akamai: interface{}{
 * AkamaiSignatureHeaderAuthenticationKeyList: media.AkamaiSignatureHeaderAuthenticationKeyArray{
 * &media.AkamaiSignatureHeaderAuthenticationKeyArgs{
 * Base64Key: pulumi.String("dGVzdGlkMQ=="),
 * Expiration: pulumi.String("2029-12-31T16:00:00-08:00"),
 * Identifier: pulumi.String("id1"),
 * },
 * &media.AkamaiSignatureHeaderAuthenticationKeyArgs{
 * Base64Key: pulumi.String("dGVzdGlkMQ=="),
 * Expiration: pulumi.String("2030-12-31T16:00:00-08:00"),
 * Identifier: pulumi.String("id2"),
 * },
 * },
 * },
 * Ip: interface{}{
 * Allow: media.IPRangeArray{
 * &media.IPRangeArgs{
 * Address: pulumi.String("192.168.1.1"),
 * Name: pulumi.String("AllowedIp"),
 * },
 * },
 * },
 * },
 * AccountName: pulumi.String("slitestmedia10"),
 * AvailabilitySetName: pulumi.String("availableset"),
 * CdnEnabled: pulumi.Bool(false),
 * Description: pulumi.String("test event 1"),
 * Location: pulumi.String("West US"),
 * ResourceGroupName: pulumi.String("mediaresources"),
 * ScaleUnits: pulumi.Int(1),
 * StreamingEndpointName: pulumi.String("myStreamingEndpoint1"),
 * Tags: pulumi.StringMap{
 * "tag1": pulumi.String("value1"),
 * "tag2": pulumi.String("value2"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingEndpoint;
 * import com.pulumi.azurenative.media.StreamingEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingEndpoint = new StreamingEndpoint("streamingEndpoint", StreamingEndpointArgs.builder()
 *             .accessControl(Map.ofEntries(
 *                 Map.entry("akamai", Map.of("akamaiSignatureHeaderAuthenticationKeyList",
 *                     Map.ofEntries(
 *                         Map.entry("base64Key", "dGVzdGlkMQ=="),
 *                         Map.entry("expiration", "2029-12-31T16:00:00-08:00"),
 *                         Map.entry("identifier", "id1")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("base64Key", "dGVzdGlkMQ=="),
 *                         Map.entry("expiration", "2030-12-31T16:00:00-08:00"),
 *                         Map.entry("identifier", "id2")
 *                     ))),
 *                 Map.entry("ip", Map.of("allow", Map.ofEntries(
 *                     Map.entry("address", "192.168.1.1"),
 *                     Map.entry("name", "AllowedIp")
 *                 )))
 *             ))
 *             .accountName("slitestmedia10")
 *             .availabilitySetName("availableset")
 *             .cdnEnabled(false)
 *             .description("test event 1")
 *             .location("West US")
 *             .resourceGroupName("mediaresources")
 *             .scaleUnits(1)
 *             .streamingEndpointName("myStreamingEndpoint1")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:StreamingEndpoint myStreamingEndpoint1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaservices/{accountName}/streamingEndpoints/{streamingEndpointName}
 * ```
 * @property accessControl The access control definition of the streaming endpoint.
 * @property accountName The Media Services account name.
 * @property autoStart The flag indicates if the resource should be automatically started on creation.
 * @property availabilitySetName This feature is deprecated, do not set a value for this property.
 * @property cdnEnabled The CDN enabled flag.
 * @property cdnProfile The CDN profile name.
 * @property cdnProvider The CDN provider name.
 * @property crossSiteAccessPolicies The streaming endpoint access policies.
 * @property customHostNames The custom host names of the streaming endpoint
 * @property description The streaming endpoint description.
 * @property location The geo-location where the resource lives
 * @property maxCacheAge Max cache age
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property scaleUnits The number of scale units. Use the Scale operation to adjust this value.
 * @property sku The streaming endpoint sku.
 * @property streamingEndpointName The name of the streaming endpoint, maximum length is 24.
 * @property tags Resource tags.
 */
public data class StreamingEndpointArgs(
    public val accessControl: Output<StreamingEndpointAccessControlArgs>? = null,
    public val accountName: Output<String>? = null,
    public val autoStart: Output<Boolean>? = null,
    public val availabilitySetName: Output<String>? = null,
    public val cdnEnabled: Output<Boolean>? = null,
    public val cdnProfile: Output<String>? = null,
    public val cdnProvider: Output<String>? = null,
    public val crossSiteAccessPolicies: Output<CrossSiteAccessPoliciesArgs>? = null,
    public val customHostNames: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val location: Output<String>? = null,
    public val maxCacheAge: Output<Double>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scaleUnits: Output<Int>? = null,
    public val sku: Output<ArmStreamingEndpointCurrentSkuArgs>? = null,
    public val streamingEndpointName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.StreamingEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.media.StreamingEndpointArgs =
        com.pulumi.azurenative.media.StreamingEndpointArgs.builder()
            .accessControl(accessControl?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .autoStart(autoStart?.applyValue({ args0 -> args0 }))
            .availabilitySetName(availabilitySetName?.applyValue({ args0 -> args0 }))
            .cdnEnabled(cdnEnabled?.applyValue({ args0 -> args0 }))
            .cdnProfile(cdnProfile?.applyValue({ args0 -> args0 }))
            .cdnProvider(cdnProvider?.applyValue({ args0 -> args0 }))
            .crossSiteAccessPolicies(
                crossSiteAccessPolicies?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customHostNames(customHostNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .maxCacheAge(maxCacheAge?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scaleUnits(scaleUnits?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .streamingEndpointName(streamingEndpointName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StreamingEndpointArgs].
 */
@PulumiTagMarker
public class StreamingEndpointArgsBuilder internal constructor() {
    private var accessControl: Output<StreamingEndpointAccessControlArgs>? = null

    private var accountName: Output<String>? = null

    private var autoStart: Output<Boolean>? = null

    private var availabilitySetName: Output<String>? = null

    private var cdnEnabled: Output<Boolean>? = null

    private var cdnProfile: Output<String>? = null

    private var cdnProvider: Output<String>? = null

    private var crossSiteAccessPolicies: Output<CrossSiteAccessPoliciesArgs>? = null

    private var customHostNames: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var location: Output<String>? = null

    private var maxCacheAge: Output<Double>? = null

    private var resourceGroupName: Output<String>? = null

    private var scaleUnits: Output<Int>? = null

    private var sku: Output<ArmStreamingEndpointCurrentSkuArgs>? = null

    private var streamingEndpointName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The access control definition of the streaming endpoint.
     */
    @JvmName("oigjvwsuueiddxhr")
    public suspend fun accessControl(`value`: Output<StreamingEndpointAccessControlArgs>) {
        this.accessControl = value
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("ccghvgemjhdqhgtu")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The flag indicates if the resource should be automatically started on creation.
     */
    @JvmName("gsklpndiwjmixyni")
    public suspend fun autoStart(`value`: Output<Boolean>) {
        this.autoStart = value
    }

    /**
     * @param value This feature is deprecated, do not set a value for this property.
     */
    @JvmName("etnsstcmtepowfom")
    public suspend fun availabilitySetName(`value`: Output<String>) {
        this.availabilitySetName = value
    }

    /**
     * @param value The CDN enabled flag.
     */
    @JvmName("eucpvyowfrugjiew")
    public suspend fun cdnEnabled(`value`: Output<Boolean>) {
        this.cdnEnabled = value
    }

    /**
     * @param value The CDN profile name.
     */
    @JvmName("kjyihkplrqnptkor")
    public suspend fun cdnProfile(`value`: Output<String>) {
        this.cdnProfile = value
    }

    /**
     * @param value The CDN provider name.
     */
    @JvmName("fptfpiqeamrrdhfr")
    public suspend fun cdnProvider(`value`: Output<String>) {
        this.cdnProvider = value
    }

    /**
     * @param value The streaming endpoint access policies.
     */
    @JvmName("dhqwqoustnxryojv")
    public suspend fun crossSiteAccessPolicies(`value`: Output<CrossSiteAccessPoliciesArgs>) {
        this.crossSiteAccessPolicies = value
    }

    /**
     * @param value The custom host names of the streaming endpoint
     */
    @JvmName("vaopbfvsjsuxbgpa")
    public suspend fun customHostNames(`value`: Output<List<String>>) {
        this.customHostNames = value
    }

    @JvmName("vnnucthgertuqmol")
    public suspend fun customHostNames(vararg values: Output<String>) {
        this.customHostNames = Output.all(values.asList())
    }

    /**
     * @param values The custom host names of the streaming endpoint
     */
    @JvmName("aqwxcskxeuphhlsw")
    public suspend fun customHostNames(values: List<Output<String>>) {
        this.customHostNames = Output.all(values)
    }

    /**
     * @param value The streaming endpoint description.
     */
    @JvmName("dipnchwfdutjujpc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("agqafrkhlncvrnjv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Max cache age
     */
    @JvmName("wtylwppstqfimmnl")
    public suspend fun maxCacheAge(`value`: Output<Double>) {
        this.maxCacheAge = value
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("onrtkurlwyjmgwqy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The number of scale units. Use the Scale operation to adjust this value.
     */
    @JvmName("hhxwnbljcvmnrxrk")
    public suspend fun scaleUnits(`value`: Output<Int>) {
        this.scaleUnits = value
    }

    /**
     * @param value The streaming endpoint sku.
     */
    @JvmName("kgreffaitmqtuujy")
    public suspend fun sku(`value`: Output<ArmStreamingEndpointCurrentSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The name of the streaming endpoint, maximum length is 24.
     */
    @JvmName("rmtkyrgbxpcysmbw")
    public suspend fun streamingEndpointName(`value`: Output<String>) {
        this.streamingEndpointName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("iwercqrcxsvwcbuc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The access control definition of the streaming endpoint.
     */
    @JvmName("gyagmcrqhhytkqgp")
    public suspend fun accessControl(`value`: StreamingEndpointAccessControlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessControl = mapped
    }

    /**
     * @param argument The access control definition of the streaming endpoint.
     */
    @JvmName("dkwgseipfpgkwaok")
    public suspend
    fun accessControl(argument: suspend StreamingEndpointAccessControlArgsBuilder.() -> Unit) {
        val toBeMapped = StreamingEndpointAccessControlArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessControl = mapped
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("nhqnddtnsfbjqtph")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The flag indicates if the resource should be automatically started on creation.
     */
    @JvmName("qntdphbxpoypmdmh")
    public suspend fun autoStart(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoStart = mapped
    }

    /**
     * @param value This feature is deprecated, do not set a value for this property.
     */
    @JvmName("rorgtsthdvejaohl")
    public suspend fun availabilitySetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilitySetName = mapped
    }

    /**
     * @param value The CDN enabled flag.
     */
    @JvmName("ngxvwadchurepejm")
    public suspend fun cdnEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdnEnabled = mapped
    }

    /**
     * @param value The CDN profile name.
     */
    @JvmName("tkallgjiungtwpxm")
    public suspend fun cdnProfile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdnProfile = mapped
    }

    /**
     * @param value The CDN provider name.
     */
    @JvmName("wjtygcoknqwbxwxb")
    public suspend fun cdnProvider(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdnProvider = mapped
    }

    /**
     * @param value The streaming endpoint access policies.
     */
    @JvmName("sxcovaoetbekxrlf")
    public suspend fun crossSiteAccessPolicies(`value`: CrossSiteAccessPoliciesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossSiteAccessPolicies = mapped
    }

    /**
     * @param argument The streaming endpoint access policies.
     */
    @JvmName("sbjryrvdlmnmoxhx")
    public suspend
    fun crossSiteAccessPolicies(argument: suspend CrossSiteAccessPoliciesArgsBuilder.() -> Unit) {
        val toBeMapped = CrossSiteAccessPoliciesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.crossSiteAccessPolicies = mapped
    }

    /**
     * @param value The custom host names of the streaming endpoint
     */
    @JvmName("oqrfvvmncuriadvg")
    public suspend fun customHostNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customHostNames = mapped
    }

    /**
     * @param values The custom host names of the streaming endpoint
     */
    @JvmName("ypjmistcbkkpcmpn")
    public suspend fun customHostNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customHostNames = mapped
    }

    /**
     * @param value The streaming endpoint description.
     */
    @JvmName("tbkfnicteamxasir")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wjlgtsmjnvlwxcmi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Max cache age
     */
    @JvmName("jkpacwxtruxfugtq")
    public suspend fun maxCacheAge(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCacheAge = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("eigyqafoekqqsohg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The number of scale units. Use the Scale operation to adjust this value.
     */
    @JvmName("mympmxnevlqbtvkw")
    public suspend fun scaleUnits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleUnits = mapped
    }

    /**
     * @param value The streaming endpoint sku.
     */
    @JvmName("mbljplqhngkwkbec")
    public suspend fun sku(`value`: ArmStreamingEndpointCurrentSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The streaming endpoint sku.
     */
    @JvmName("hkieaxkpjtromulr")
    public suspend fun sku(argument: suspend ArmStreamingEndpointCurrentSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ArmStreamingEndpointCurrentSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The name of the streaming endpoint, maximum length is 24.
     */
    @JvmName("afiwxjgraanxmkkl")
    public suspend fun streamingEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamingEndpointName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("isfdniwqftixtrph")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("kofqkrijqjhqmill")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StreamingEndpointArgs = StreamingEndpointArgs(
        accessControl = accessControl,
        accountName = accountName,
        autoStart = autoStart,
        availabilitySetName = availabilitySetName,
        cdnEnabled = cdnEnabled,
        cdnProfile = cdnProfile,
        cdnProvider = cdnProvider,
        crossSiteAccessPolicies = crossSiteAccessPolicies,
        customHostNames = customHostNames,
        description = description,
        location = location,
        maxCacheAge = maxCacheAge,
        resourceGroupName = resourceGroupName,
        scaleUnits = scaleUnits,
        sku = sku,
        streamingEndpointName = streamingEndpointName,
        tags = tags,
    )
}
