@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of key used to encrypt the Account Key.
 */
public enum class AccountEncryptionKeyType(
    public val javaValue: com.pulumi.azurenative.media.enums.AccountEncryptionKeyType,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.AccountEncryptionKeyType> {
    /**
     * The Account Key is encrypted with a System Key.
     */
    SystemKey(com.pulumi.azurenative.media.enums.AccountEncryptionKeyType.SystemKey),

    /**
     * The Account Key is encrypted with a Customer Key.
     */
    CustomerKey(com.pulumi.azurenative.media.enums.AccountEncryptionKeyType.CustomerKey),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.AccountEncryptionKeyType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.AccountEncryptionKeyType):
            AccountEncryptionKeyType =
            AccountEncryptionKeyType.values().first { it.javaValue == javaType }
    }
}
