@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The deinterlacing mode. Defaults to AutoPixelAdaptive.
 */
public enum class DeinterlaceMode(
    public val javaValue: com.pulumi.azurenative.media.enums.DeinterlaceMode,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.DeinterlaceMode> {
    /**
     * Disables de-interlacing of the source video.
     */
    Off(com.pulumi.azurenative.media.enums.DeinterlaceMode.Off),

    /**
     * Apply automatic pixel adaptive de-interlacing on each frame in the input video.
     */
    AutoPixelAdaptive(com.pulumi.azurenative.media.enums.DeinterlaceMode.AutoPixelAdaptive),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.DeinterlaceMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.DeinterlaceMode):
            DeinterlaceMode = DeinterlaceMode.values().first { it.javaValue == javaType }
    }
}
