@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The minimum TLS version allowed for this account's requests. This is an optional property. If unspecified, a secure default value will be used.
 */
public enum class MinimumTlsVersion(
    public val javaValue: com.pulumi.azurenative.media.enums.MinimumTlsVersion,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.MinimumTlsVersion> {
    /**
     * Minimum TLS version is TLS 1.0.
     */
    Tls10(com.pulumi.azurenative.media.enums.MinimumTlsVersion.Tls10),

    /**
     * Minimum TLS version is TLS 1.1.
     */
    Tls11(com.pulumi.azurenative.media.enums.MinimumTlsVersion.Tls11),

    /**
     * Minimum TLS version is TLS 1.2.
     */
    Tls12(com.pulumi.azurenative.media.enums.MinimumTlsVersion.Tls12),

    /**
     * Minimum TLS version is TLS 1.3.
     */
    Tls13(com.pulumi.azurenative.media.enums.MinimumTlsVersion.Tls13),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.MinimumTlsVersion = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.MinimumTlsVersion):
            MinimumTlsVersion = MinimumTlsVersion.values().first { it.javaValue == javaType }
    }
}
