@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for processing TransformOutputs. The default priority is Normal.
 */
public enum class Priority(
    public val javaValue: com.pulumi.azurenative.media.enums.Priority,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.Priority> {
    /**
     * Used for TransformOutputs that can be generated after Normal and High priority TransformOutputs.
     */
    Low(com.pulumi.azurenative.media.enums.Priority.Low),

    /**
     * Used for TransformOutputs that can be generated at Normal priority.
     */
    Normal(com.pulumi.azurenative.media.enums.Priority.Normal),

    /**
     * Used for TransformOutputs that should take precedence over others.
     */
    High(com.pulumi.azurenative.media.enums.Priority.High),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.Priority = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.Priority): Priority =
            Priority.values().first { it.javaValue == javaType }
    }
}
